/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage.source.common;

import java.util.Objects;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.source.IndirectEntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractEntityDamageSource;

public abstract class AbstractIndirectEntityDamageSource
implements IndirectEntityDamageSource {
    private final DamageType apiDamageType;
    private final boolean absolute;
    private final boolean bypassesArmor;
    private final boolean scales;
    private final boolean explosive;
    private final boolean magic;
    private final boolean creative;
    private final double exhaustion;
    private final Entity source;
    private final Entity indirect;

    protected AbstractIndirectEntityDamageSource(AbstractIndirectEntityDamageSourceBuilder<?, ?> builder) {
        this.apiDamageType = Objects.requireNonNull(builder.damageType, "DamageType cannot be null!");
        this.absolute = builder.absolute;
        this.bypassesArmor = builder.bypasses;
        this.scales = builder.scales;
        this.explosive = builder.explosion;
        this.magic = builder.magical;
        this.creative = builder.creative;
        this.exhaustion = builder.exhaustion != null ? builder.exhaustion : (this.absolute || this.bypassesArmor ? 0.0 : 0.1);
        this.source = Objects.requireNonNull(builder.sourceEntity, "Entity source cannot be null!");
        this.indirect = Objects.requireNonNull(builder.indirect, "Indirect source cannot be null!");
    }

    @Override
    public Entity getSource() {
        return this.source;
    }

    @Override
    public DamageType getType() {
        return this.apiDamageType;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean isBypassingArmor() {
        return this.bypassesArmor;
    }

    @Override
    public boolean isScaledByDifficulty() {
        return this.scales;
    }

    @Override
    public boolean isExplosive() {
        return this.explosive;
    }

    @Override
    public boolean isMagic() {
        return this.magic;
    }

    @Override
    public boolean doesAffectCreative() {
        return this.creative;
    }

    @Override
    public Entity getIndirectSource() {
        return this.indirect;
    }

    @Override
    public double getExhaustion() {
        return this.exhaustion;
    }

    public static abstract class AbstractIndirectEntityDamageSourceBuilder<T extends IndirectEntityDamageSource, B extends IndirectEntityDamageSource.AbstractBuilder<T, B>>
    extends AbstractEntityDamageSource.AbstractEntityDamageSourceBuilder<T, B>
    implements IndirectEntityDamageSource.AbstractBuilder<T, B> {
        protected Entity sourceEntity;
        protected Entity indirect;

        @Override
        public B entity(Entity entity) {
            this.sourceEntity = Objects.requireNonNull(entity, "Entity source cannot be null!");
            return (B)this;
        }

        @Override
        public B proxySource(Entity projectile) {
            this.indirect = Objects.requireNonNull(projectile);
            return (B)this;
        }

        @Override
        public B reset() {
            super.reset();
            this.sourceEntity = null;
            this.indirect = null;
            return (B)this;
        }
    }
}

