/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.impl.entity.AbstractAffectEntityEvent;
import org.spongepowered.api.util.annotation.eventgen.ImplementedBy;
import org.spongepowered.api.util.annotation.eventgen.PropertySettings;
import org.spongepowered.api.world.ServerLocation;

@ImplementedBy(value=AbstractAffectEntityEvent.class)
public interface AffectEntityEvent
extends Event,
Cancellable {
    @PropertySettings(requiredParameter=false, generateMethods=false)
    public List<EntitySnapshot> getEntitySnapshots() throws IllegalStateException;

    public List<Entity> getEntities();

    default public List<Entity> filterEntityLocations(Predicate<ServerLocation> predicate) {
        ArrayList<Entity> removedEntities = new ArrayList<Entity>();
        Iterator<Entity> i = this.getEntities().iterator();
        while (i.hasNext()) {
            Entity entity = i.next();
            if (entity.getLocation().onServer().map(predicate::test).orElse(false).booleanValue()) continue;
            i.remove();
            removedEntities.add(entity);
        }
        return removedEntities;
    }

    default public List<? extends Entity> filterEntities(Predicate<Entity> predicate) {
        ArrayList<Entity> removedEntities = new ArrayList<Entity>();
        Iterator<Entity> i = this.getEntities().iterator();
        while (i.hasNext()) {
            Entity entity = i.next();
            if (predicate.test(entity)) continue;
            i.remove();
            removedEntities.add(entity);
        }
        return removedEntities;
    }
}

