/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class AABB {
    private final Vector3d min;
    private final Vector3d max;
    private @Nullable Vector3d size = null;
    private @Nullable Vector3d center = null;

    public AABB(Vector3i firstCorner, Vector3i secondCorner) {
        this(Objects.requireNonNull(firstCorner, "firstCorner").toDouble(), Objects.requireNonNull(secondCorner, "secondCorner").toDouble());
    }

    public AABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        this(new Vector3d(x1, y1, z1), new Vector3d(x2, y2, z2));
    }

    public AABB(Vector3d firstCorner, Vector3d secondCorner) {
        Objects.requireNonNull(firstCorner, "firstCorner");
        Objects.requireNonNull(secondCorner, "secondCorner");
        this.min = firstCorner.min(secondCorner);
        this.max = firstCorner.max(secondCorner);
        if (this.min.getX() == this.max.getX()) {
            throw new IllegalArgumentException("The box is generate on x!");
        }
        if (this.min.getY() == this.max.getY()) {
            throw new IllegalArgumentException("The box is generate on y!");
        }
        if (this.min.getZ() == this.max.getZ()) {
            throw new IllegalArgumentException("The box is generate on z!");
        }
    }

    public Vector3d getMin() {
        return this.min;
    }

    public Vector3d getMax() {
        return this.max;
    }

    public Vector3d getCenter() {
        if (this.center == null) {
            this.center = this.min.add(this.getSize().div(2.0f));
        }
        return this.center;
    }

    public Vector3d getSize() {
        if (this.size == null) {
            this.size = this.max.sub(this.min);
        }
        return this.size;
    }

    public boolean contains(Vector3i point) {
        Objects.requireNonNull(point, "point");
        return this.contains(point.getX(), point.getY(), point.getZ());
    }

    public boolean contains(Vector3d point) {
        Objects.requireNonNull(point, "point");
        return this.contains(point.getX(), point.getY(), point.getZ());
    }

    public boolean contains(double x, double y, double z) {
        return this.min.getX() <= x && this.max.getX() >= x && this.min.getY() <= y && this.max.getY() >= y && this.min.getZ() <= z && this.max.getZ() >= z;
    }

    public boolean intersects(AABB other) {
        Objects.requireNonNull(other, "other");
        return this.max.getX() >= other.getMin().getX() && other.getMax().getX() >= this.min.getX() && this.max.getY() >= other.getMin().getY() && other.getMax().getY() >= this.min.getY() && this.max.getZ() >= other.getMin().getZ() && other.getMax().getZ() >= this.min.getZ();
    }

    public Optional<Tuple<Vector3d, Vector3d>> intersects(Vector3d start, Vector3d direction) {
        Vector3d normal;
        double t;
        Vector3d zNormal;
        double tzMax;
        double tzMin;
        Vector3d normalMax;
        double tMax;
        Vector3d normalMin;
        double tMin;
        Vector3d yNormal;
        double tyMax;
        double tyMin;
        Vector3d xNormal;
        double txMax;
        double txMin;
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(direction, "direction");
        if (Math.copySign(1.0, direction.getX()) > 0.0) {
            txMin = (this.min.getX() - start.getX()) / direction.getX();
            txMax = (this.max.getX() - start.getX()) / direction.getX();
            xNormal = Vector3d.UNIT_X;
        } else {
            txMin = (this.max.getX() - start.getX()) / direction.getX();
            txMax = (this.min.getX() - start.getX()) / direction.getX();
            xNormal = Vector3d.UNIT_X.negate();
        }
        if (Math.copySign(1.0, direction.getY()) > 0.0) {
            tyMin = (this.min.getY() - start.getY()) / direction.getY();
            tyMax = (this.max.getY() - start.getY()) / direction.getY();
            yNormal = Vector3d.UNIT_Y;
        } else {
            tyMin = (this.max.getY() - start.getY()) / direction.getY();
            tyMax = (this.min.getY() - start.getY()) / direction.getY();
            yNormal = Vector3d.UNIT_Y.negate();
        }
        if (txMin > tyMax || txMax < tyMin) {
            return Optional.empty();
        }
        if (tyMin == txMin) {
            tMin = tyMin;
            normalMin = xNormal.negate().sub(yNormal);
        } else if (tyMin > txMin) {
            tMin = tyMin;
            normalMin = yNormal.negate();
        } else {
            tMin = txMin;
            normalMin = xNormal.negate();
        }
        if (tyMax == txMax) {
            tMax = tyMax;
            normalMax = xNormal.add(yNormal);
        } else if (tyMax < txMax) {
            tMax = tyMax;
            normalMax = yNormal;
        } else {
            tMax = txMax;
            normalMax = xNormal;
        }
        if (Math.copySign(1.0, direction.getZ()) > 0.0) {
            tzMin = (this.min.getZ() - start.getZ()) / direction.getZ();
            tzMax = (this.max.getZ() - start.getZ()) / direction.getZ();
            zNormal = Vector3d.UNIT_Z;
        } else {
            tzMin = (this.max.getZ() - start.getZ()) / direction.getZ();
            tzMax = (this.min.getZ() - start.getZ()) / direction.getZ();
            zNormal = Vector3d.UNIT_Z.negate();
        }
        if (tMin > tzMax || tMax < tzMin) {
            return Optional.empty();
        }
        if (tzMin == tMin) {
            normalMin = normalMin.sub(zNormal);
        } else if (tzMin > tMin) {
            tMin = tzMin;
            normalMin = zNormal.negate();
        }
        if (tzMax == tMax) {
            normalMax = normalMax.add(zNormal);
        } else if (tzMax < tMax) {
            tMax = tzMax;
            normalMax = zNormal;
        }
        if (tMax < 0.0) {
            return Optional.empty();
        }
        if (tMin < 0.0) {
            t = tMax;
            normal = normalMax;
        } else {
            t = tMin;
            normal = normalMin;
        }
        normal = normal.normalize();
        double x = normal.getX() > 0.0 ? this.max.getX() : (normal.getX() < 0.0 ? this.min.getX() : direction.getX() * t + start.getX());
        double y = normal.getY() > 0.0 ? this.max.getY() : (normal.getY() < 0.0 ? this.min.getY() : direction.getY() * t + start.getY());
        double z = normal.getZ() > 0.0 ? this.max.getZ() : (normal.getZ() < 0.0 ? this.min.getZ() : direction.getZ() * t + start.getZ());
        return Optional.of(new Tuple<Vector3d, Vector3d>(new Vector3d(x, y, z), normal));
    }

    public AABB offset(Vector3i offset) {
        Objects.requireNonNull(offset, "offset");
        return this.offset(offset.getX(), offset.getY(), offset.getZ());
    }

    public AABB offset(Vector3d offset) {
        Objects.requireNonNull(offset, "offset");
        return this.offset(offset.getX(), offset.getY(), offset.getZ());
    }

    public AABB offset(double x, double y, double z) {
        return new AABB(this.min.add(x, y, z), this.max.add(x, y, z));
    }

    public AABB expand(Vector3i amount) {
        Objects.requireNonNull(amount, "amount");
        return this.expand(amount.getX(), amount.getY(), amount.getZ());
    }

    public AABB expand(Vector3d amount) {
        Objects.requireNonNull(amount, "amount");
        return this.expand(amount.getX(), amount.getY(), amount.getZ());
    }

    public AABB expand(double x, double y, double z) {
        return new AABB(this.min.sub(x /= 2.0, y /= 2.0, z /= 2.0), this.max.add(x, y, z));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AABB)) {
            return false;
        }
        AABB aabb = (AABB)other;
        return this.min.equals((Object)aabb.min) && this.max.equals((Object)aabb.max);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }

    public String toString() {
        return "AABB(" + this.min + " to " + this.max + ")";
    }
}

