/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;

public abstract class RandomObjectTable<T>
implements Collection<TableEntry<T>> {
    protected final List<TableEntry<T>> entries = Lists.newArrayList();
    private VariableAmount rolls;

    public RandomObjectTable(int rolls) {
        if (rolls < 0) {
            throw new IllegalArgumentException("Rolls cannot be negative!");
        }
        this.rolls = VariableAmount.fixed(rolls);
    }

    public RandomObjectTable(VariableAmount rolls) {
        this.rolls = Objects.requireNonNull(rolls);
    }

    public VariableAmount getRolls() {
        return this.rolls;
    }

    public void setRolls(VariableAmount rolls) {
        this.rolls = Objects.requireNonNull(rolls);
    }

    public void setRolls(int rolls) {
        if (rolls < 0) {
            throw new IllegalArgumentException("Rolls cannot be negative!");
        }
        this.rolls = VariableAmount.fixed(rolls);
    }

    @Override
    public boolean add(TableEntry<T> entry) {
        Objects.requireNonNull(entry);
        if (entry.getWeight() < 0.0) {
            throw new IllegalArgumentException("Weight cannot be negative!");
        }
        return this.entries.add(entry);
    }

    public boolean add(T object, double weight) {
        Objects.requireNonNull(object);
        if (weight < 0.0) {
            throw new IllegalArgumentException("Weight cannot be negative!");
        }
        return this.add(new WeightedObject<T>(object, weight));
    }

    @Override
    public boolean addAll(Collection<? extends TableEntry<T>> c) {
        boolean flag = false;
        for (TableEntry<T> e : c) {
            if (e == null) continue;
            this.add(e);
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean contains(Object o) {
        return this.entries.contains(o);
    }

    public boolean containsObject(Object obj) {
        boolean entry = this.entries.contains(obj);
        if (entry) {
            return true;
        }
        for (TableEntry<T> e : this.entries) {
            if (!(e instanceof WeightedObject) || !((WeightedObject)e).get().equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entries.containsAll(c);
    }

    public boolean containsAllObjects(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean remove(Object entry) {
        return this.entries.remove(entry);
    }

    public boolean removeObject(Object object) {
        boolean flag = this.entries.remove(object);
        if (flag) {
            return true;
        }
        Iterator<TableEntry<T>> it = this.entries.iterator();
        while (it.hasNext()) {
            TableEntry<T> e = it.next();
            if (!(e instanceof WeightedObject) || !((WeightedObject)e).get().equals(object)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.entries.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.entries.retainAll(c);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    public abstract List<T> get(Random var1);

    public List<TableEntry<T>> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    @Override
    public Iterator<TableEntry<T>> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.entries.toArray(a);
    }
}

