/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.schematic;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;

@CatalogedBy(value={PaletteTypes.class})
public interface Palette<T> {
    public PaletteType<T> getType();

    public int getHighestId();

    public Optional<T> get(int var1);

    public OptionalInt get(T var1);

    public Stream<T> stream();

    public Mutable<T> asMutable();

    public Immutable<T> asImmutable();

    public static interface Immutable<I>
    extends Palette<I> {
        @Override
        default public Immutable<I> asImmutable() {
            return this;
        }
    }

    public static interface Mutable<M>
    extends Palette<M> {
        public int getOrAssign(M var1);

        public boolean remove(M var1);

        @Override
        default public Mutable<M> asMutable() {
            return this;
        }
    }
}

