/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.schematic;

import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolumeCreator;
import org.spongepowered.api.world.volume.archetype.entity.ReadableEntityArchetypeVolume;
import org.spongepowered.api.world.volume.biome.MutableBiomeVolume;
import org.spongepowered.api.world.volume.block.ReadableBlockVolume;
import org.spongepowered.api.world.volume.block.entity.ReadableBlockEntityVolume;
import org.spongepowered.api.world.volume.game.LocationBaseDataHolder;
import org.spongepowered.math.vector.Vector3d;

public interface Schematic
extends ArchetypeVolume,
LocationBaseDataHolder.Mutable {
    public static final String METADATA_NAME = "Name";
    public static final String METADATA_AUTHOR = "Author";
    public static final String METADATA_DATE = "Date";
    public static final String METADATA_REQUIRED_MODS = "RequiredMods";

    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public Palette<BlockState> getBlockPalette();

    public Palette<BiomeType> getBiomePalette();

    public DataView getMetadata();

    public Optional<MutableBiomeVolume<?>> getBiomeVolume();

    public ListMultimap<Vector3d, EntityArchetype> getEntitiesByPosition();

    public static interface Builder
    extends CopyableBuilder<Schematic, Builder> {
        public Builder blocks(ReadableBlockVolume var1);

        public Builder blockEntities(ReadableBlockEntityVolume var1);

        public Builder entities(ReadableEntityArchetypeVolume var1);

        public Builder creator(ArchetypeVolumeCreator var1);

        public Builder volume(ArchetypeVolume var1);

        public Builder blockPalette(Palette<BlockState> var1);

        public Builder biomePalette(Palette<BiomeType> var1);

        public Builder blockPaletteType(PaletteType<BlockState> var1);

        public Builder biomePaletteType(PaletteType<BiomeType> var1);

        public Builder entity(EntityArchetype var1);

        public Builder entity(EntityArchetype var1, Vector3d var2);

        public Builder entities(Collection<EntityArchetype> var1);

        public Builder metadata(DataView var1);

        public Builder metaValue(String var1, Object var2);

        public Schematic build() throws IllegalArgumentException;
    }
}

