/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.ArrayList;
import org.spongepowered.api.Sponge;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeLifecycle;
import org.spongepowered.common.inject.SpongeCommonModule;
import org.spongepowered.common.inject.SpongeGuice;
import org.spongepowered.common.inject.SpongeModule;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.network.channel.SpongeChannelRegistry;
import org.spongepowered.common.network.packet.SpongePacketHandler;
import org.spongepowered.plugin.Blackboard;

public final class SpongeBootstrap {
    private static SpongeLifecycle lifecycle;
    public static Blackboard.Key<Injector> PARENT_INJECTOR;

    public static void perform(String engineName, Runnable engineStart) {
        Stage stage = SpongeGuice.getInjectorStage(((Launch)Launch.getInstance()).getInjectionStage());
        SpongeCommon.getLogger().debug("Creating injector in stage '{}'", (Object)stage);
        ArrayList modules = Lists.newArrayList((Object[])new Module[]{new SpongeModule(), new SpongeCommonModule()});
        Injector bootstrapInjector = Guice.createInjector((Stage)stage, (Iterable)modules);
        ((Launch)Launch.getInstance()).getPluginEngine().getPluginEnvironment().getBlackboard().getOrCreate(PARENT_INJECTOR, () -> bootstrapInjector);
        lifecycle = (SpongeLifecycle)bootstrapInjector.getInstance(SpongeLifecycle.class);
        ((Launch)Launch.getInstance()).loadPlugins();
        lifecycle.establishFactories();
        lifecycle.establishBuilders();
        lifecycle.initTimings();
        lifecycle.registerPluginListeners();
        lifecycle.callConstructEvent();
        lifecycle.callRegisterFactoryEvent();
        lifecycle.callRegisterBuilderEvent();
        lifecycle.callRegisterChannelEvent();
        lifecycle.establishGameServices();
        lifecycle.establishDataKeyListeners();
        SpongePacketHandler.init((SpongeChannelRegistry)Sponge.getChannelRegistry());
        ((Launch)Launch.getInstance()).getLogger().info("Loading Minecraft {}, please wait...", (Object)engineName);
        engineStart.run();
    }

    public static SpongeLifecycle getLifecycle() {
        return lifecycle;
    }

    static {
        PARENT_INJECTOR = Blackboard.Key.of((String)"parent_injector", Injector.class);
    }
}

