/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongePlatform
implements Platform {
    private final PluginContainer apiPlugin;
    private final PluginContainer platformPlugin;
    private final PluginContainer minecraftPlugin;
    private final MinecraftVersion minecraftVersion;
    protected final Map<String, Object> platformMap = new HashMap<String, Object>(){
        private static final long serialVersionUID = 7022397614988467398L;

        @Override
        public Object put(String key, Object value) {
            Preconditions.checkArgument((!this.containsKey(key) ? 1 : 0) != 0, (String)"Cannot set the value of the existing key %s", (Object)key);
            return super.put(key, value);
        }
    };

    @Inject
    public SpongePlatform(MinecraftVersion minecraftVersion) {
        this.minecraftVersion = (MinecraftVersion)Preconditions.checkNotNull((Object)minecraftVersion, (Object)"minecraftVersion");
        this.apiPlugin = ((Launch)Launch.getInstance()).getApiPlugin();
        this.platformPlugin = ((Launch)Launch.getInstance()).getPlatformPlugin();
        this.minecraftPlugin = ((Launch)Launch.getInstance()).getMinecraftPlugin();
        PluginContainer common = ((Launch)Launch.getInstance()).getCommonPlugin();
        this.platformMap.put("Type", (Object)this.getType());
        this.platformMap.put("ApiName", this.apiPlugin.getMetadata().getName());
        this.platformMap.put("ApiVersion", this.apiPlugin.getMetadata().getVersion());
        this.platformMap.put("CommonName", common.getMetadata().getName());
        this.platformMap.put("CommonVersion", common.getMetadata().getVersion());
        this.platformMap.put("ImplementationName", this.platformPlugin.getMetadata().getName());
        this.platformMap.put("ImplementationVersion", this.platformPlugin.getMetadata().getVersion());
        this.platformMap.put("MinecraftVersion", this.getMinecraftVersion());
    }

    @Override
    public Platform.Type getType() {
        return !((Launch)Launch.getInstance()).isDedicatedServer() ? Platform.Type.CLIENT : Platform.Type.SERVER;
    }

    @Override
    public Platform.Type getExecutionType() {
        if (Sponge.isServerAvailable() && Sponge.getServer().onMainThread()) {
            return Platform.Type.SERVER;
        }
        if (Sponge.isClientAvailable() && Sponge.getClient().onMainThread()) {
            return Platform.Type.CLIENT;
        }
        return Platform.Type.UNKNOWN;
    }

    @Override
    public PluginContainer getContainer(Platform.Component component) {
        switch (component) {
            case API: {
                return this.apiPlugin;
            }
            case IMPLEMENTATION: {
                return this.platformPlugin;
            }
            case GAME: {
                return this.minecraftPlugin;
            }
        }
        throw new AssertionError((Object)("Unknown platform component: " + (Object)((Object)component)));
    }

    @Override
    public final MinecraftVersion getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    public final Map<String, Object> asMap() {
        return this.platformMap;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("executionType", (Object)this.getExecutionType()).add("api", (Object)this.apiPlugin.getMetadata().getId()).add("implementation", (Object)this.platformPlugin.getMetadata().getId()).add("minecraftVersion", (Object)this.getMinecraftVersion()).toString();
    }
}

