/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.common.advancement.SpongeTrigger;

public class SpongeFilteredTrigger
implements ICriterionInstance,
FilteredTrigger {
    private static final Gson GSON = new Gson();
    private final SpongeTrigger triggerType;
    private final FilteredTriggerConfiguration configuration;

    SpongeFilteredTrigger(SpongeTrigger triggerType, FilteredTriggerConfiguration configuration) {
        this.triggerType = triggerType;
        this.configuration = configuration;
    }

    public ResourceLocation getId() {
        return this.triggerType.getId();
    }

    public Trigger getType() {
        return (Trigger)((Object)this.triggerType);
    }

    public FilteredTriggerConfiguration getConfiguration() {
        return this.configuration;
    }

    public JsonElement serialize() {
        if (this.configuration instanceof DataSerializable) {
            DataContainer dataContainer = ((DataSerializable)((Object)this.configuration)).toContainer();
            try {
                String json = DataFormats.JSON.get().write(dataContainer);
                return GSON.fromJson(json, JsonElement.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return GSON.toJsonTree(this.configuration);
    }
}

