/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.TreeLayout;
import org.spongepowered.api.advancement.TreeLayoutElement;

public final class SpongeTreeLayout
implements TreeLayout {
    private final AdvancementTree tree;

    public SpongeTreeLayout(AdvancementTree tree) {
        this.tree = tree;
    }

    @Override
    public AdvancementTree getTree() {
        return this.tree;
    }

    @Override
    public Collection<TreeLayoutElement> getElements() {
        ImmutableSet.Builder elements = ImmutableSet.builder();
        SpongeTreeLayout.collectElements(this.tree.getRootAdvancement(), (ImmutableSet.Builder<TreeLayoutElement>)elements);
        return elements.build();
    }

    private static void collectElements(Advancement advancement, ImmutableSet.Builder<TreeLayoutElement> elements) {
        advancement.getDisplayInfo().ifPresent(displayInfo -> elements.add((Object)((TreeLayoutElement)((Object)displayInfo))));
        advancement.getChildren().forEach(child -> SpongeTreeLayout.collectElements(child, elements));
    }

    @Override
    public Optional<TreeLayoutElement> getElement(Advancement advancement) {
        Optional<AdvancementTree> tree = advancement.getTree();
        if (!(tree.isPresent() && advancement.getDisplayInfo().isPresent() && tree.get().equals(this.tree))) {
            return Optional.empty();
        }
        return SpongeTreeLayout.findElementInfo(this.tree.getRootAdvancement(), advancement.getKey()).map(TreeLayoutElement.class::cast);
    }

    private static Optional<DisplayInfo> findElementInfo(Advancement advancement, ResourceKey key) {
        if (advancement.getKey().equals(key)) {
            return advancement.getDisplayInfo();
        }
        for (Advancement child : advancement.getChildren()) {
            Optional<DisplayInfo> info = SpongeTreeLayout.findElementInfo(child, key);
            if (!info.isPresent()) continue;
            return info;
        }
        return Optional.empty();
    }
}

