/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class VanillaBossBarListener
implements BossBar.Listener {
    private final ServerBossInfo vanilla;

    public VanillaBossBarListener(ServerBossInfo vanilla) {
        this.vanilla = vanilla;
    }

    public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        this.sendPacket(SUpdateBossInfoPacket.Operation.UPDATE_NAME);
    }

    public void bossBarProgressChanged(@NonNull BossBar bar, float oldProgress, float newProgress) {
        this.sendPacket(SUpdateBossInfoPacket.Operation.UPDATE_PCT);
    }

    public void bossBarColorChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color newColor) {
        this.sendPacket(SUpdateBossInfoPacket.Operation.UPDATE_STYLE);
    }

    public void bossBarOverlayChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay newOverlay) {
        this.sendPacket(SUpdateBossInfoPacket.Operation.UPDATE_STYLE);
    }

    public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsAdded, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsRemoved) {
        this.sendPacket(SUpdateBossInfoPacket.Operation.UPDATE_PROPERTIES);
    }

    private void sendPacket(SUpdateBossInfoPacket.Operation action) {
        SUpdateBossInfoPacket packet = new SUpdateBossInfoPacket(action, (BossInfo)this.vanilla);
        for (ServerPlayerEntity player : this.vanilla.getPlayers()) {
            player.connection.sendPacket((IPacket)packet);
        }
    }
}

