/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.common;

import org.spongepowered.common.applaunch.config.common.EigenRedstoneCategory;
import org.spongepowered.common.applaunch.config.common.StructureSaveCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ConfigSerializable
public class OptimizationCategory {
    @Setting(value="drops-pre-merge")
    @Comment(value="If 'true', block item drops are pre-processed to avoid \nhaving to spawn extra entities that will be merged post spawning. \nUsually, Sponge is smart enough to determine when to attempt an item pre-merge \nand when not to, however, in certain cases, some mods rely on items not being \npre-merged and actually spawned, in which case, the items will flow right through \nwithout being merged.")
    private boolean preItemDropMerge = false;
    @Setting(value="cache-tameable-owners")
    @Comment(value="Caches tameable entities owners to avoid constant lookups against data watchers. If mods \ncause issues, disable this.")
    private boolean cacheTameableOwners = true;
    @Setting(value="structure-saving")
    @Comment(value="Handles structures that are saved to disk. Certain structures can take up large amounts \nof disk space for very large maps and the data for these structures is only needed while the \nworld around them is generating. Disabling saving of these structures can save disk space and \ntime during saves if your world is already fully generated. \nWarning: disabling structure saving will break the vanilla locate command.")
    private StructureSaveCategory structureSaving = new StructureSaveCategory();
    @Setting(value="eigen-redstone")
    @Comment(value="Uses theosib's redstone algorithms to completely overhaul the way redstone works.")
    private EigenRedstoneCategory eigenRedstone = new EigenRedstoneCategory();
    @Setting(value="faster-thread-checks")
    @Comment(value="If 'true', allows for Sponge to make better assumptions on single threaded\noperations with relation to various checks for server threaded operations.\nThis is default to true due to Sponge being able to precisely inject when\nthe server thread is available. This should make an already fast operation\nmuch faster for better thread checks to ensure stability of sponge's systems.")
    private boolean fasterThreadChecks = true;
    @Setting(value="map-optimization")
    @Comment(value="If 'true', re-writes the incredibly inefficient Vanilla Map code.\nThis yields enormous performance enhancements when using many maps, but has a tiny chance of breaking mods that invasively modify Vanilla.It is strongly reccomended to keep this on, unless explicitly advised otherwise by a Sponge developer")
    private boolean mapOptimization = true;
    @Setting(value="optimize-hoppers")
    @Comment(value="Based on Aikar's optimizationo of Hoppers, setting this to 'true'\nwill allow for hoppers to save performing server -> client updates\nwhen transferring items. Because hoppers can transfer items multiple\ntimes per tick, these updates can get costly on the server, with\nlittle to no benefit to the client. Because of the nature of the\nchange, the default will be 'false' due to the inability to pre-emptively\nforetell whether mod compatibility will fail with these changes or not.\nRefer to: https://github.com/PaperMC/Paper/blob/8175ec916f31dcd130fe0884fe46bdc187d829aa/Spigot-Server-Patches/0269-Optimize-Hoppers.patch\nfor more details.")
    private boolean optimizeHoppers = false;
    @Setting(value="use-active-chunks-for-collisions")
    @Comment(value="Vanilla performs a lot of is area loaded checks during\nentity collision calculations with blocks, and because\nthese calculations require fetching the chunks to see\nif they are loaded, before getting the block states\nfrom those chunks, there can be some small performance\nincrease by checking the entity's owned active chunk\nit may currently reside in. Essentially, instead of\nasking the world if those chunks are loaded, the entity\nwould know whether it's chunks are loaded and that neighbor's\nchunks are loaded.")
    private boolean useActiveChunkForCollisions = false;
    @Setting(value="tileentity-ticking-optimization")
    @Comment(value="Based on Paper's TileEntity Ticking optimization\nsetting this to 'true' prevents unnecessary ticking in Chests and EnderChests\nSee https://github.com/PaperMC/Paper/blob/bb4002d82e355f033906fc894cc2320f665ba72d/Spigot-Server-Patches/0022-Optimize-TileEntity-Ticking.patch")
    private boolean optimizeTileEntityTicking = true;
    @Setting(value="disable-failing-deserialization-log-spam")
    @Comment(value="Occasionally, some built in advancements, \nrecipes, etc. can fail to deserialize properly\nwhich ends up potentially spamming the server log\nand the original provider of the failing content\nis not able to fix. This provides an option to\nsuppress the exceptions printing out in the log.")
    private boolean disableFailingAdvancementDeserialization = true;
    @Setting(value="disable-scheduled-updates-for-persistent-leaf-blocks")
    @Comment(value="Leaf blocks placed by players will normally schedule\nupdates for themselves after placement, and on neighboring\nplacement. This optimization is relatively small but effectively\ndisables scheduling updates and reactive updates to leaves that\nare `persistent`. Does not drastically improve performance.")
    private boolean disableLeafBlockScheduledUpdatesForPersistedLeaves = true;

    public OptimizationCategory() {
        this.preItemDropMerge = SpongeConfigs.getPluginEnvironment().getBlackboard().get(SpongeConfigs.IS_VANILLA_PLATFORM).orElse(true);
    }

    public StructureSaveCategory getStructureSaving() {
        return this.structureSaving;
    }

    public boolean useStructureSave() {
        return this.structureSaving.isEnabled();
    }

    public boolean useMapOptimization() {
        return this.mapOptimization;
    }

    public boolean doDropsPreMergeItemDrops() {
        return this.preItemDropMerge;
    }

    public boolean useCacheTameableOwners() {
        return this.cacheTameableOwners;
    }

    public EigenRedstoneCategory getEigenRedstoneCategory() {
        return this.eigenRedstone;
    }

    public boolean useEigenRedstone() {
        return this.eigenRedstone.isEnabled();
    }

    public boolean useFastThreadChecks() {
        return this.fasterThreadChecks;
    }

    public boolean isOptimizeHoppers() {
        return this.optimizeHoppers;
    }

    public boolean isUseActiveChunkForCollisions() {
        return this.useActiveChunkForCollisions;
    }

    public boolean isOptimizedTileEntityTicking() {
        return this.optimizeTileEntityTicking;
    }

    public boolean disableFailingAdvancementDeserialization() {
        return this.disableFailingAdvancementDeserialization;
    }

    public boolean isDisableLeafBlockScheduledUpdatesForPersistedLeaves() {
        return this.disableLeafBlockScheduledUpdatesForPersistedLeaves;
    }
}

