/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.common.command.brigadier.SpongeParameterTranslator;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.brigadier.tree.SpongeLiteralCommandNode;

public final class SpongeParameterizedCommand
implements Command.Parameterized {
    private final List<Parameter.Subcommand> subcommands;
    private final List<Parameter> parameters;
    private final List<Flag> flags;
    private final Function<CommandCause, Optional<Component>> shortDescription;
    private final Function<CommandCause, Optional<Component>> extendedDescription;
    private final Predicate<CommandCause> executionRequirements;
    private final @Nullable CommandExecutor executor;
    private final boolean isTerminal;
    private @Nullable SpongeCommandDispatcher cachedDispatcher;

    SpongeParameterizedCommand(List<Parameter.Subcommand> subcommands, List<Parameter> parameters, Function<CommandCause, Optional<Component>> shortDescription, Function<CommandCause, Optional<Component>> extendedDescription, Predicate<CommandCause> executionRequirements, @Nullable CommandExecutor executor, List<Flag> flags, boolean isTerminal) {
        this.subcommands = subcommands;
        this.parameters = parameters;
        this.shortDescription = shortDescription;
        this.extendedDescription = extendedDescription;
        this.executionRequirements = executionRequirements;
        this.executor = executor;
        this.flags = flags;
        this.isTerminal = isTerminal;
    }

    @Override
    public @NonNull List<String> getSuggestions(@NonNull CommandCause cause, @NonNull String arguments) {
        SpongeCommandDispatcher dispatcher = this.getCachedDispatcher();
        ParseResults<CommandSource> parseResults = dispatcher.parse(arguments, (CommandSource)cause);
        Suggestions suggestions = (Suggestions)dispatcher.getCompletionSuggestions(parseResults).join();
        return suggestions.getList().stream().map(x -> x.apply(arguments)).collect(Collectors.toList());
    }

    @Override
    public boolean canExecute(@NonNull CommandCause cause) {
        return this.getExecutionRequirements().test(cause);
    }

    @Override
    public @NonNull Optional<Component> getShortDescription(@NonNull CommandCause cause) {
        return this.shortDescription.apply(cause);
    }

    @Override
    public @NonNull Optional<Component> getExtendedDescription(@NonNull CommandCause cause) {
        return this.extendedDescription.apply(cause);
    }

    @Override
    public @NonNull Component getUsage(@NonNull CommandCause cause) {
        Collection usage = Arrays.stream(this.getCachedDispatcher().getAllUsage((CommandNode)this.getCachedDispatcher().getRoot(), (CommandSource)cause, true)).map(Component::text).collect(Collectors.toList());
        return Component.join((ComponentLike)Component.newline(), (Iterable)usage);
    }

    @Override
    public List<Flag> flags() {
        return new ArrayList<Flag>(this.flags);
    }

    @Override
    public @NonNull List<Parameter> parameters() {
        return new ArrayList<Parameter>(this.parameters);
    }

    @Override
    public List<Parameter.Subcommand> subcommands() {
        return new ArrayList<Parameter.Subcommand>(this.subcommands);
    }

    @Override
    public boolean isTerminal() {
        return this.isTerminal;
    }

    @Override
    public @NonNull Predicate<CommandCause> getExecutionRequirements() {
        return this.executionRequirements;
    }

    @Override
    public @NonNull CommandContext parseArguments(@NonNull CommandCause cause, @NonNull String arguments) {
        ParseResults<CommandSource> results = this.getCachedDispatcher().parse(new StringReader(arguments), (CommandSource)cause);
        return (CommandContext)results.getContext().build(arguments);
    }

    @Override
    public Optional<CommandExecutor> getExecutor() {
        return Optional.ofNullable(this.executor);
    }

    private SpongeCommandDispatcher getCachedDispatcher() {
        if (this.cachedDispatcher == null) {
            this.cachedDispatcher = new SpongeCommandDispatcher();
            this.cachedDispatcher.register(this.buildWithAlias("command"));
        }
        return this.cachedDispatcher;
    }

    public LiteralCommandNode<CommandSource> buildWithAlias(String primaryAlias) {
        LiteralArgumentBuilder primary = LiteralArgumentBuilder.literal((String)primaryAlias);
        primary.requires(this.getExecutionRequirements());
        if (this.executor == null) {
            return (LiteralCommandNode)SpongeParameterTranslator.createCommandTreeWithSubcommandsOnly(primary, this.subcommands);
        }
        return (LiteralCommandNode)SpongeParameterTranslator.createCommandTree(primary, this);
    }

    public Collection<LiteralCommandNode<CommandSource>> buildWithAliases(Iterable<String> aliases) {
        Iterator<String> iterable = aliases.iterator();
        LiteralCommandNode<CommandSource> built = this.buildWithAlias(iterable.next());
        ArrayList<LiteralCommandNode<CommandSource>> nodes = new ArrayList<LiteralCommandNode<CommandSource>>();
        nodes.add(built);
        while (iterable.hasNext()) {
            LiteralArgumentBuilder secondary = LiteralArgumentBuilder.literal((String)iterable.next());
            secondary.executes(built.getCommand());
            secondary.requires(built.getRequirement());
            nodes.add(new SpongeLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)secondary.redirect(built)), this));
        }
        return nodes;
    }
}

