/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.common.command.SpongeParameterizedCommand;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.argument.CustomArgumentParser;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNodeBuilder;
import org.spongepowered.common.command.brigadier.tree.SpongeCommandExecutorWrapper;
import org.spongepowered.common.command.brigadier.tree.SpongeFlagLiteralCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeLiteralCommandNode;
import org.spongepowered.common.command.parameter.SpongeDefaultValueParser;
import org.spongepowered.common.command.parameter.SpongeParameterKey;
import org.spongepowered.common.command.parameter.SpongeParameterValue;
import org.spongepowered.common.command.parameter.multi.SpongeMultiParameter;
import org.spongepowered.common.command.parameter.multi.SpongeSequenceParameter;

public final class SpongeParameterTranslator {
    private static final ValueCompleter EMPTY_COMPLETER = (context, currentInput) -> Collections.emptyList();

    public static CommandNode<CommandSource> createCommandTreeWithSubcommandsOnly(@NonNull ArgumentBuilder<CommandSource, ?> rootNode, @NonNull List<Parameter.Subcommand> subcommands) {
        SpongeParameterTranslator.createSubcommands(rootNode, subcommands);
        return rootNode.build();
    }

    public static CommandNode<CommandSource> createCommandTree(@NonNull ArgumentBuilder<CommandSource, ?> rootNode, @NonNull SpongeParameterizedCommand command) {
        SpongeCommandExecutorWrapper executorWrapper = command.getExecutor().map(SpongeCommandExecutorWrapper::new).orElse(null);
        ListIterator<Parameter> parameterListIterator = command.parameters().listIterator();
        boolean isTerminal = SpongeParameterTranslator.createNode(parameterListIterator, executorWrapper, arg_0 -> rootNode.then(arg_0), null, new ArrayList<CommandNode<CommandSource>>(), true, false, true);
        if (isTerminal && executorWrapper != null) {
            rootNode.executes((Command)executorWrapper);
        }
        SpongeParameterTranslator.createSubcommands(rootNode, command.subcommands());
        Object builtNode = rootNode instanceof LiteralArgumentBuilder ? new SpongeLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)rootNode), command) : rootNode.build();
        SpongeParameterTranslator.createFlags(command.flags(), (CommandNode<CommandSource>)builtNode, isTerminal ? executorWrapper : null);
        return builtNode;
    }

    public static void createFlags(List<Flag> flags, CommandNode<CommandSource> node, @Nullable SpongeCommandExecutorWrapper wrapper) {
        for (Flag flag : flags) {
            Iterator<String> aliasIterator = flag.getAliases().iterator();
            LiteralArgumentBuilder flagLiteral = LiteralArgumentBuilder.literal((String)aliasIterator.next());
            flagLiteral.requires(flag.getRequirement());
            if (flag.getAssociatedParameter().isPresent()) {
                Parameter parameter = flag.getAssociatedParameter().get();
                List<Parameter> parameters = parameter instanceof SpongeSequenceParameter ? ((SpongeSequenceParameter)parameter).getParameterCandidates() : Collections.singletonList(parameter);
                boolean isTerminal = SpongeParameterTranslator.createNode(parameters.listIterator(), wrapper, arg_0 -> ((LiteralArgumentBuilder)flagLiteral).then(arg_0), builder -> {
                    if (builder.getArguments().isEmpty()) {
                        builder.redirect(node);
                    } else {
                        node.getChildren().forEach(arg_0 -> ((ArgumentBuilder)builder).then(arg_0));
                    }
                }, new ArrayList<CommandNode<CommandSource>>(), wrapper != null, false, false);
                if (isTerminal) {
                    flagLiteral.executes((Command)wrapper);
                    flagLiteral.redirect(node);
                }
            } else {
                flagLiteral.executes((Command)wrapper);
                flagLiteral.redirect(node);
            }
            SpongeFlagLiteralCommandNode flagNode = new SpongeFlagLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)flagLiteral, flag);
            node.addChild((CommandNode)flagNode);
            while (aliasIterator.hasNext()) {
                LiteralArgumentBuilder nextFlag = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)aliasIterator.next()).executes(flagNode.getCommand());
                if (flagNode.getRedirect() != null) {
                    nextFlag.redirect(flagNode.getRedirect());
                } else {
                    nextFlag.redirect((CommandNode)flagNode);
                }
                node.addChild((CommandNode)new SpongeFlagLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)nextFlag, flag));
            }
        }
    }

    public static boolean createNode(@NonNull ListIterator<Parameter> parameters, @Nullable SpongeCommandExecutorWrapper executorWrapper, @NonNull Consumer<CommandNode<CommandSource>> builtNodeConsumer, @Nullable Consumer<ArgumentBuilder<CommandSource, ?>> lastNodeCallback, List<CommandNode<CommandSource>> potentialOptionalRedirects, boolean canBeTerminal, boolean previousWasOptional, boolean isContainerAtEnd) {
        return SpongeParameterTranslator.createNode(parameters, executorWrapper, builtNodeConsumer, lastNodeCallback, potentialOptionalRedirects, canBeTerminal, previousWasOptional, null, isContainerAtEnd);
    }

    public static boolean createNode(@NonNull ListIterator<Parameter> parameters, @Nullable SpongeCommandExecutorWrapper executorWrapper, @NonNull Consumer<CommandNode<CommandSource>> builtNodeConsumer, @Nullable Consumer<ArgumentBuilder<CommandSource, ?>> lastNodeCallback, List<CommandNode<CommandSource>> potentialOptionalRedirects, boolean canBeTerminal, boolean previousWasOptional, @Nullable String suffix, boolean isContainerAtEnd) {
        boolean isInferredTermination;
        if (!parameters.hasNext()) {
            return canBeTerminal;
        }
        Parameter currentParameter = parameters.next();
        boolean hasNext = parameters.hasNext();
        boolean isDefault = currentParameter instanceof SpongeParameterValue && ((SpongeParameterValue)currentParameter).getDefaultParser() != null;
        boolean bl = isInferredTermination = canBeTerminal && !hasNext;
        if (currentParameter instanceof Parameter.Subcommand) {
            SpongeParameterTranslator.createSubcommand((Parameter.Subcommand)currentParameter, builtNodeConsumer);
            return false;
        }
        if (currentParameter instanceof SpongeMultiParameter) {
            boolean isMultiParameterContainerAtEnd = isContainerAtEnd && !hasNext;
            Consumer<ArgumentBuilder<CommandSource, ?>> nodeCallback = isInferredTermination ? lastNodeCallback : arg -> SpongeParameterTranslator.createNode(parameters, executorWrapper, arg_0 -> ((ArgumentBuilder)arg).then(arg_0), lastNodeCallback, potentialOptionalRedirects, canBeTerminal, currentParameter.isOptional(), isMultiParameterContainerAtEnd);
            isInferredTermination = ((SpongeMultiParameter)currentParameter).createNode(executorWrapper, builtNodeConsumer, nodeCallback, potentialOptionalRedirects, isInferredTermination, previousWasOptional, suffix, isMultiParameterContainerAtEnd) || isInferredTermination;
        } else if (currentParameter instanceof Parameter.Value) {
            Parameter.Value valueParameter = (Parameter.Value)currentParameter;
            boolean isConsumeAll = valueParameter.willConsumeAllRemaining();
            isInferredTermination |= valueParameter.isTerminal() || isConsumeAll;
            if (isConsumeAll && hasNext) {
                throw new IllegalStateException("A parameter that consumes all must be at the end of a parameter chain.");
            }
            boolean isParameterAtEnd = isContainerAtEnd && !hasNext;
            List<SpongeArgumentCommandNodeBuilder<ArgumentBuilder<CommandSource, ?>>> currentNodes = SpongeParameterTranslator.createNode(valueParameter, suffix, isParameterAtEnd);
            SpongeArgumentCommandNodeBuilder currentNode = currentNodes.get(0);
            if (parameters.hasNext()) {
                boolean bl2 = isInferredTermination = SpongeParameterTranslator.createNode(parameters, executorWrapper, arg_0 -> currentNode.then(arg_0), lastNodeCallback, potentialOptionalRedirects, canBeTerminal, currentParameter.isOptional(), isContainerAtEnd) && canBeTerminal || isInferredTermination;
            }
            if (isInferredTermination || valueParameter.isTerminal()) {
                if (isParameterAtEnd) {
                    currentNodes.removeIf(SpongeArgumentCommandNodeBuilder::isEmptyOptional);
                }
                currentNodes.forEach(x -> {
                    SpongeArgumentCommandNodeBuilder cfr_ignored_0 = (SpongeArgumentCommandNodeBuilder)x.executes(executorWrapper);
                });
            }
            if (!(executorWrapper != null && hasNext || lastNodeCallback == null)) {
                currentNodes.forEach(lastNodeCallback);
            }
            SpongeArgumentCommandNode builtNode = currentNode.build();
            builtNodeConsumer.accept((CommandNode<CommandSource>)builtNode);
            if (isConsumeAll) {
                builtNode.addChild((CommandNode)((SpongeArgumentCommandNodeBuilder)currentNode.redirect((CommandNode)builtNode)).build());
            }
            ArrayList newOptionals = new ArrayList();
            for (int i = 1; i < currentNodes.size(); ++i) {
                SpongeArgumentCommandNodeBuilder secondaryBuilder = currentNodes.get(i);
                if (isParameterAtEnd) {
                    secondaryBuilder.executes(executorWrapper);
                } else if (potentialOptionalRedirects.isEmpty()) {
                    secondaryBuilder.redirect((CommandNode)builtNode);
                } else if (secondaryBuilder.getRedirect() == null) {
                    potentialOptionalRedirects.forEach(arg_0 -> secondaryBuilder.then(arg_0));
                } else {
                    CommandNode nodeToAppendTo = secondaryBuilder.getRedirect();
                    while (nodeToAppendTo.getRedirect() != null) {
                        nodeToAppendTo = nodeToAppendTo.getRedirect();
                    }
                    potentialOptionalRedirects.forEach(arg_0 -> ((CommandNode)nodeToAppendTo).addChild(arg_0));
                }
                SpongeArgumentCommandNode secondaryNode = secondaryBuilder.build();
                newOptionals.add(secondaryNode);
                builtNodeConsumer.accept((CommandNode<CommandSource>)secondaryNode);
            }
            potentialOptionalRedirects.clear();
            potentialOptionalRedirects.addAll(newOptionals);
        }
        return canBeTerminal && isInferredTermination && currentParameter.isOptional() && !isDefault;
    }

    private static void createSubcommands(ArgumentBuilder<CommandSource, ?> rootNode, List<Parameter.Subcommand> parameters) {
        parameters.forEach(x -> SpongeParameterTranslator.createSubcommand(x, arg_0 -> ((ArgumentBuilder)rootNode).then(arg_0)));
    }

    private static void createSubcommand(@NonNull Parameter.Subcommand parameter, Consumer<? super LiteralCommandNode<CommandSource>> nodeConsumer) {
        Collection<LiteralCommandNode<CommandSource>> builtNodes = ((SpongeParameterizedCommand)parameter.getCommand()).buildWithAliases(parameter.getAliases());
        builtNodes.forEach(nodeConsumer);
    }

    private static <T> @NonNull List<SpongeArgumentCommandNodeBuilder<? extends T>> createNode(@NonNull Parameter.Value<T> parameter, @Nullable String suffix, boolean isEndOfContainer) {
        ArgumentParser type = null;
        if (parameter instanceof SpongeParameterValue) {
            type = ((SpongeParameterValue)parameter).getArgumentTypeIfStandard();
        }
        if (type == null) {
            type = new CustomArgumentParser(parameter.getParsers(), parameter.getCompleter(), false);
        }
        SpongeArgumentCommandNodeBuilder<T> argumentBuilder = new SpongeArgumentCommandNodeBuilder<T>(SpongeParameterKey.getSpongeKey(parameter.getKey()), type, parameter.getCompleter(), parameter.getValueUsage().orElse(null), suffix, false);
        argumentBuilder.requires(parameter.getRequirement());
        ArrayList<SpongeArgumentCommandNodeBuilder<T>> nodes = new ArrayList<SpongeArgumentCommandNodeBuilder<T>>();
        nodes.add(argumentBuilder);
        if (parameter instanceof SpongeParameterValue && parameter.isOptional()) {
            boolean isEmptyOptional;
            String suffixSuffix;
            CustomArgumentParser optionalParser;
            SpongeDefaultValueParser defaultValueParser = ((SpongeParameterValue)parameter).getDefaultParser();
            if (defaultValueParser != null) {
                optionalParser = new CustomArgumentParser(Collections.singletonList(defaultValueParser), EMPTY_COMPLETER, true);
                suffixSuffix = suffix + "_default";
                isEmptyOptional = false;
            } else {
                if (isEndOfContainer) {
                    return nodes;
                }
                optionalParser = new CustomArgumentParser(Collections.emptyList(), EMPTY_COMPLETER, true);
                suffixSuffix = suffix + "_optional";
                isEmptyOptional = true;
            }
            SpongeArgumentCommandNodeBuilder optionalBuilder = new SpongeArgumentCommandNodeBuilder(SpongeParameterKey.getSpongeKey(parameter.getKey()), optionalParser, EMPTY_COMPLETER, parameter.getValueUsage().orElse(null), suffixSuffix, isEmptyOptional);
            nodes.add(optionalBuilder);
        }
        return nodes;
    }
}

