/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.argument;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.command.CommandSource;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.common.command.brigadier.SpongeImmutableArgumentReader;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContext;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;

public abstract class AbstractArgumentParser<T>
implements ArgumentParser<T>,
SuggestionProvider<CommandSource>,
ValueParameter<T> {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d+");

    @Override
    public T parse(Parameter.Key<? super T> key, SpongeCommandContextBuilder contextBuilder, SpongeStringReader reader) throws CommandSyntaxException {
        SpongeImmutableArgumentReader state = reader.getImmutable();
        CommandContext.Builder.Transaction transaction = contextBuilder.startTransaction();
        try {
            Optional value = this.getValue(key, reader, contextBuilder);
            contextBuilder.commit(transaction);
            if (value.isPresent()) {
                return value.get();
            }
        }
        catch (ArgumentParseException e) {
            reader.setState(state);
            contextBuilder.rollback(transaction);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)e.getSuperText());
        }
        return null;
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        for (String s2 : this.complete((SpongeCommandContext)context, builder.getRemaining())) {
            if (INTEGER_PATTERN.matcher(s2).matches()) {
                try {
                    builder.suggest(Integer.parseInt(s2));
                }
                catch (NumberFormatException ex) {
                    builder.suggest(s2);
                }
                continue;
            }
            if (!s2.toLowerCase(Locale.ROOT).startsWith(builder.getRemaining())) continue;
            builder.suggest(s2);
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return ImmutableList.of();
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSource> context, SuggestionsBuilder builder) {
        return this.listSuggestions(context, builder);
    }

    @Override
    public boolean doesNotRead() {
        return false;
    }
}

