/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.argument;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;

public class StandardArgumentParser<S, T>
implements ArgumentParser<T>,
ValueParameter<T> {
    private final ArgumentType<S> type;
    private final Converter<S, T> converter;

    public static <T> StandardArgumentParser<T, T> createIdentity(ArgumentType<T> type) {
        return new StandardArgumentParser<Object, Object>(type, (reader, c, x) -> x);
    }

    public static <S, T> StandardArgumentParser<S, T> createConverter(ArgumentType<S> type, Converter<S, T> converter) {
        return new StandardArgumentParser<S, T>(type, converter);
    }

    protected StandardArgumentParser(ArgumentType<S> type, Converter<S, T> converter) {
        this.type = type;
        this.converter = converter;
    }

    @Override
    public T parse(Parameter.Key<? super T> key, SpongeCommandContextBuilder contextBuilder, SpongeStringReader reader) throws CommandSyntaxException {
        return this.converter.convert(reader, contextBuilder, this.type.parse((StringReader)reader));
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        return this.type.listSuggestions(context, builder);
    }

    @Override
    public Collection<String> getExamples() {
        return this.type.getExamples();
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return ImmutableList.of(this.type);
    }

    @Override
    public boolean doesNotRead() {
        return false;
    }

    @Override
    public @NonNull List<String> complete(@NonNull org.spongepowered.api.command.parameter.CommandContext context, String currentInput) {
        SuggestionsBuilder suggestionsBuilder = new SuggestionsBuilder(currentInput, 0);
        this.listSuggestions((CommandContext)context, suggestionsBuilder);
        return suggestionsBuilder.build().getList().stream().map(Suggestion::getText).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<? extends T> getValue( @NonNull Parameter.Key<? super T> parameterKey,  @NonNull ArgumentReader.Mutable reader,  @NonNull CommandContext.Builder context) throws ArgumentParseException {
        try {
            return Optional.of(this.parse(parameterKey, (SpongeCommandContextBuilder)context, (SpongeStringReader)reader));
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)e.getMessage()), (Throwable)e, e.getInput(), e.getCursor());
        }
    }

    @FunctionalInterface
    public static interface Converter<S, T> {
        public T convert(StringReader var1, SpongeCommandContextBuilder var2, S var3) throws CommandSyntaxException;
    }
}

