/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.parameter.Parameter;

public final class SpongeParameterKey<T>
implements Parameter.Key<T> {
    private static final Map<Parameter.Key<?>, SpongeParameterKey<?>> keyCache = new HashMap();
    private final String key;
    private final Type type;

    public static <T> SpongeParameterKey<T> getSpongeKey( @NonNull Parameter.Key<? super T> key) {
        if (key instanceof SpongeParameterKey) {
            return (SpongeParameterKey)key;
        }
        return keyCache.computeIfAbsent(key, SpongeParameterKey::new);
    }

    private SpongeParameterKey( @NonNull Parameter.Key<T> parameterKey) {
        this.key = parameterKey.key();
        this.type = parameterKey.getType();
    }

    public SpongeParameterKey(@NonNull String key, @NonNull Type type) {
        this.key = key;
        this.type = type;
    }

    @Override
    public @NonNull String key() {
        return this.key;
    }

    @Override
    public @NonNull Type getType() {
        return this.type;
    }

    @Override
    public boolean isInstance(Object value) {
        return value != null && GenericTypeReflector.erase(this.type).isInstance(value);
    }

    @Override
    public T cast(Object value) {
        return (T)value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeParameterKey that = (SpongeParameterKey)o;
        return this.key.equals(that.key) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type);
    }

    public String toString() {
        return "Key: " + this.key + ", Class " + this.type.getTypeName();
    }
}

