/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.builder;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.common.command.parameter.managed.standard.SpongeChoicesValueParameter;

public final class SpongeDynamicChoicesBuilder<T>
implements VariableValueParameters.DynamicChoicesBuilder<T> {
    private @Nullable Supplier<? extends Collection<String>> choices = null;
    private @Nullable Function<String, ? extends T> results = null;
    private boolean showInUsage = false;

    @Override
    public  @NonNull VariableValueParameters.DynamicChoicesBuilder<T> setChoicesAndResults(@NonNull Supplier<Map<String, ? extends T>> choices) {
        this.choices = () -> ((Map)choices.get()).keySet();
        this.results = x -> ((Map)choices.get()).get(x);
        return this;
    }

    @Override
    public  @NonNull VariableValueParameters.DynamicChoicesBuilder<T> setChoices(Supplier<? extends Collection<String>> choices) {
        this.choices = choices;
        return this;
    }

    @Override
    public  @NonNull VariableValueParameters.DynamicChoicesBuilder<T> setResults(@NonNull Function<String, ? extends T> results) {
        this.results = results;
        return this;
    }

    @Override
    public  @NonNull VariableValueParameters.DynamicChoicesBuilder<T> setShowInUsage(boolean showInUsage) {
        this.showInUsage = showInUsage;
        return this;
    }

    @Override
    public @NonNull ValueParameter<T> build() {
        Preconditions.checkNotNull(this.choices, (Object)"choices must not be null");
        Preconditions.checkNotNull(this.results, (Object)"results must not be null");
        return new SpongeChoicesValueParameter<T>(this.choices, this.results, this.showInUsage, false);
    }

    @Override
    public  @NonNull VariableValueParameters.DynamicChoicesBuilder<T> reset() {
        this.choices = null;
        this.results = null;
        this.showInUsage = false;
        return this;
    }
}

