/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.factory;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.util.text.StringTextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.common.command.brigadier.argument.StandardArgumentParser;
import org.spongepowered.common.command.parameter.managed.builder.SpongeCatalogedElementParameterBuilder;
import org.spongepowered.common.command.parameter.managed.builder.SpongeDynamicChoicesBuilder;
import org.spongepowered.common.command.parameter.managed.builder.SpongeLiteralBuilder;
import org.spongepowered.common.command.parameter.managed.builder.SpongeNumberRangeBuilder;
import org.spongepowered.common.command.parameter.managed.builder.SpongeStaticChoicesBuilder;
import org.spongepowered.common.command.parameter.managed.standard.SpongeChoicesValueParameter;

public final class SpongeVariableValueParametersFactory
implements VariableValueParameters.Factory {
    @Override
    public <T extends Enum<T>> @NonNull ValueParameter<T> createEnumParameter(@NonNull Class<T> enumClass) {
        ImmutableMap.Builder choices = ImmutableMap.builder();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            choices.put((Object)e.name().toLowerCase(), () -> e);
        }
        return new SpongeChoicesValueParameter(choices.build(), true, true);
    }

    @Override
    public <T>  @NonNull VariableValueParameters.StaticChoicesBuilder<T> createStaticChoicesBuilder(@NonNull Class<T> returnType) {
        return new SpongeStaticChoicesBuilder();
    }

    @Override
    public <T>  @NonNull VariableValueParameters.DynamicChoicesBuilder<T> createDynamicChoicesBuilder(@NonNull Class<T> returnType) {
        return new SpongeDynamicChoicesBuilder();
    }

    @Override
    public <T extends CatalogType>  @NonNull VariableValueParameters.CatalogedTypeBuilder<T> createCatalogedTypesBuilder(@NonNull Class<T> returnType) {
        return new SpongeCatalogedElementParameterBuilder<T>(returnType);
    }

    @Override
    public <T>  @NonNull VariableValueParameters.LiteralBuilder<T> createLiteralBuilder(@NonNull Class<T> returnType) {
        return new SpongeLiteralBuilder();
    }

    @Override
    public VariableValueParameters.NumberRangeBuilder<Integer> createIntegerNumberRangeBuilder() {
        return SpongeNumberRangeBuilder.intBuilder();
    }

    @Override
    public VariableValueParameters.NumberRangeBuilder<Float> createFloatNumberRangeBuilder() {
        return SpongeNumberRangeBuilder.floatBuilder();
    }

    @Override
    public VariableValueParameters.NumberRangeBuilder<Double> createDoubleNumberRangeBuilder() {
        return SpongeNumberRangeBuilder.doubleBuilder();
    }

    @Override
    public VariableValueParameters.NumberRangeBuilder<Long> createLongNumberRangeBuilder() {
        return SpongeNumberRangeBuilder.longBuilder();
    }

    @Override
    public ValueParameter<String> createValidatedStringParameter(@NonNull Pattern pattern) {
        Objects.requireNonNull(pattern);
        return StandardArgumentParser.createConverter(StringArgumentType.string(), (reader, contextBuilder, input) -> {
            if (pattern.matcher((CharSequence)input).matches()) {
                return input;
            }
            throw new SimpleCommandExceptionType((Message)new StringTextComponent("Input \"" + input + "\" does not match required pattern \"" + pattern.pattern() + "\"")).createWithContext((ImmutableStringReader)reader);
        });
    }
}

