/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.common.command.brigadier.argument.CatalogedArgumentParser;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public final class SpongePluginContainerValueParameter
extends CatalogedArgumentParser<PluginContainer> {
    private static final ResourceKey RESOURCE_KEY = ResourceKey.sponge("plugin");

    @Override
    public @NonNull ResourceKey getKey() {
        return RESOURCE_KEY;
    }

    @Override
    public @NonNull List<String> complete(@NonNull CommandContext context, String currentInput) {
        return ((Launch)Launch.getInstance()).getPluginManager().getPlugins().stream().map(x -> x.getMetadata().getId()).filter(x -> x.startsWith(currentInput)).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<? extends PluginContainer> getValue( @NonNull Parameter.Key<? super PluginContainer> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        String id = reader.parseString();
        Optional<PluginContainer> container = ((Launch)Launch.getInstance()).getPluginManager().getPlugin(id);
        if (container.isPresent()) {
            return container;
        }
        throw reader.createException((Component)Component.text((String)("Could not find plugin with ID \"" + id + "\"")));
    }
}

