/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.multi;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.common.command.brigadier.SpongeParameterTranslator;
import org.spongepowered.common.command.brigadier.tree.SpongeCommandExecutorWrapper;
import org.spongepowered.common.command.parameter.multi.SpongeMultiParameter;
import org.spongepowered.common.command.parameter.multi.SpongeSequenceParameter;

public final class SpongeFirstOfParameter
extends SpongeMultiParameter {
    protected SpongeFirstOfParameter(List<Parameter> parameterCandidates, boolean isOptional, boolean isTerminal) {
        super(parameterCandidates, isOptional, isTerminal);
    }

    @Override
    public boolean createNode(SpongeCommandExecutorWrapper executorWrapper, Consumer<CommandNode<CommandSource>> builtNodeConsumer, Consumer<ArgumentBuilder<CommandSource, ?>> nodeCallback, List<CommandNode<CommandSource>> potentialOptionalRedirects, boolean isTermination, boolean previousWasOptional, @Nullable String suffix, boolean isContainerAtEnd) {
        boolean hasExecutor = isTermination || this.isTerminal();
        boolean first = true;
        Grabber grabber = new Grabber(builtNodeConsumer);
        Consumer<ArgumentBuilder> redirector = node -> node.redirect(grabber.grabbed);
        Object2IntOpenHashMap counter = new Object2IntOpenHashMap();
        for (Parameter parameter : this.getParameterCandidates()) {
            int original;
            if (parameter instanceof Parameter.Value) {
                original = counter.addTo((Object)((Parameter.Value)parameter).getKey().key(), 1);
            } else if (parameter instanceof Parameter.Subcommand) {
                ((Parameter.Subcommand)parameter).getAliases().forEach(x -> counter.addTo(x, 1));
                original = 0;
            } else {
                original = 0;
            }
            if (parameter instanceof SpongeSequenceParameter) {
                SpongeSequenceParameter sequenceParameter = (SpongeSequenceParameter)parameter;
                boolean grab = first && !sequenceParameter.endsWithSubcommand();
                ((SpongeSequenceParameter)parameter).createNode(executorWrapper, grab ? grabber : builtNodeConsumer, first ? nodeCallback : redirector, potentialOptionalRedirects, hasExecutor, previousWasOptional, suffix, isContainerAtEnd);
            } else {
                ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                parameters.add(parameter);
                SpongeParameterTranslator.createNode(parameters.listIterator(), executorWrapper, first && !(parameter instanceof Parameter.Subcommand) ? grabber : builtNodeConsumer, grabber.grabbed == null ? nodeCallback : redirector, first ? potentialOptionalRedirects : new ArrayList<CommandNode<CommandSource>>(potentialOptionalRedirects), hasExecutor, previousWasOptional, original == 0 ? null : String.valueOf(original), isContainerAtEnd);
            }
            if (!first || !grabber.isValid()) continue;
            first = false;
        }
        return this.getParameterCandidates().stream().anyMatch(Parameter::isOptional);
    }

    private static class Grabber
    implements Consumer<CommandNode<CommandSource>> {
        private final Consumer<CommandNode<CommandSource>> original;
        private CommandNode<CommandSource> grabbed;

        public Grabber(Consumer<CommandNode<CommandSource>> original) {
            this.original = original;
        }

        @Override
        public void accept(CommandNode<CommandSource> commandSourceCommandNode) {
            this.grabbed = commandSourceCommandNode;
            this.original.accept(commandSourceCommandNode);
        }

        public boolean isValid() {
            return this.original != null;
        }
    }
}

