/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.multi;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.common.command.parameter.multi.SpongeSequenceParameter;

public final class SpongeSequenceParameterBuilder
implements Parameter.SequenceBuilder {
    private boolean terminal;
    private boolean optional;
    private final List<Parameter> parameterList = new ArrayList<Parameter>();

    @Override
    public @NonNull Parameter.SequenceBuilder terminal() {
        this.terminal = true;
        return this;
    }

    @Override
    public @NonNull Parameter.SequenceBuilder optional() {
        this.optional = true;
        return this;
    }

    @Override
    public @NonNull Parameter.SequenceBuilder then(@NonNull Parameter parameter) {
        this.parameterList.add(parameter);
        return this;
    }

    @Override
    public @NonNull Parameter build() {
        Preconditions.checkState((!this.parameterList.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one parameter!");
        return new SpongeSequenceParameter(this.parameterList, this.optional, this.terminal);
    }

    @Override
    public @NonNull Parameter.SequenceBuilder reset() {
        this.terminal = false;
        this.optional = false;
        this.parameterList.clear();
        return this;
    }
}

