/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.registrar.tree.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.tree.CommandNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.command.ISuggestionProvider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.common.command.brigadier.tree.ForcedRedirectNode;

public abstract class AbstractCommandTreeNode<T extends CommandTreeNode<@NonNull T>, O extends CommandNode<ISuggestionProvider>>
implements CommandTreeNode<T> {
    public static final Command<ISuggestionProvider> EXECUTABLE = isp -> 1;
    private @Nullable CommandTreeNode<?> redirect = null;
    private @Nullable Map<String, AbstractCommandTreeNode<?, ?>> children = null;
    private boolean executable = false;
    private boolean customSuggestions = false;
    private Predicate<CommandCause> requirement = c -> true;

    public ImmutableMap<String, AbstractCommandTreeNode<?, ?>> getChildren() {
        if (this.children == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.children);
    }

    @Override
    public @NonNull T child(@NonNull String key, @NonNull CommandTreeNode.Argument<@NonNull ?> child) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(child);
        Preconditions.checkState((this.redirect == null ? 1 : 0) != 0, (Object)"There must be no redirect if using children nodes");
        this.checkKey(key);
        if (this.children == null) {
            this.children = new HashMap();
        }
        this.children.put(key.toLowerCase(), (AbstractCommandTreeNode)((Object)child));
        return this.getThis();
    }

    @Override
    public @NonNull T redirect(@NonNull CommandTreeNode<@NonNull ?> to) {
        Preconditions.checkNotNull(to);
        Preconditions.checkState((this.children == null ? 1 : 0) != 0, (Object)"There must be no children if using a redirect");
        this.redirect = to;
        return this.getThis();
    }

    @Override
    public @NonNull T executable() {
        this.executable = true;
        return this.getThis();
    }

    @Override
    public @NonNull T customSuggestions() {
        this.customSuggestions = true;
        return this.getThis();
    }

    @Override
    public @NonNull T requires(Predicate<CommandCause> requirement) {
        this.requirement = requirement == null ? c -> true : requirement;
        return this.getThis();
    }

    protected T getThis() {
        return (T)this;
    }

    private void checkKey(String key) {
        if (this.children != null && this.children.containsKey(key.toLowerCase())) {
            throw new IllegalArgumentException("Key " + key + " is already set.");
        }
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isCustomSuggestions() {
        return this.customSuggestions;
    }

    public @Nullable CommandTreeNode<?> getRedirect() {
        return this.redirect;
    }

    protected abstract O createElement(String var1);

    protected final void addChildNodesToTree(CommandCause cause, CommandNode<ISuggestionProvider> node, Map<AbstractCommandTreeNode<?, ?>, CommandNode<ISuggestionProvider>> nodeToSuggestionProvider, Map<ForcedRedirectNode, AbstractCommandTreeNode<?, ?>> redirectsToApply) {
        this.getChildren().forEach((key, value) -> {
            if (value.requirement.test(cause)) {
                CommandNode providerCommandNode = nodeToSuggestionProvider.computeIfAbsent((AbstractCommandTreeNode<?, ?>)value, k -> {
                    Object ret = k.createElement((String)key);
                    if (k.redirect instanceof AbstractCommandTreeNode && ret instanceof ForcedRedirectNode) {
                        redirectsToApply.put((ForcedRedirectNode)ret, (AbstractCommandTreeNode)k.redirect);
                    } else {
                        k.addChildNodesToTree(cause, (CommandNode<ISuggestionProvider>)ret, nodeToSuggestionProvider, redirectsToApply);
                    }
                    return ret;
                });
                node.addChild(providerCommandNode);
            }
        });
    }

    protected final Predicate<CommandCause> getRequirement() {
        return this.requirement;
    }
}

