/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.result;

import com.google.common.base.Preconditions;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.common.command.result.SpongeCommandResult;

public final class SpongeCommandResultBuilder
implements CommandResult.Builder {
    private int result;
    private @Nullable Component errorMessage;

    @Override
    public @NonNull CommandResult.Builder setResult(int result) {
        Preconditions.checkArgument((result >= 0 ? 1 : 0) != 0, (Object)"Result must be non-negative!");
        this.result = result;
        return this;
    }

    @Override
    public @NonNull CommandResult.Builder error(@Nullable Component errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public @NonNull CommandResult build() {
        return new SpongeCommandResult(this.errorMessage == null && this.result > 0, this.result, this.errorMessage);
    }

    @Override
    public @NonNull CommandResult.Builder reset() {
        this.result = 0;
        this.errorMessage = null;
        return this;
    }
}

