/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public class WorldCategory {
    @Setting(value="auto-save-interval")
    @Comment(value="The auto-save tick interval used to save all loaded chunks in a world. \nSet to 0 to disable. (Default: 6000) \nNote: 20 ticks is equivalent to 1 second.")
    private int autoSaveInterval = 6000;
    @Setting(value="mob-spawn-range")
    @Comment(value="Specifies the radius (in chunks) of where creatures will spawn. \nThis value is capped to the current view distance setting in server.properties")
    private int mobSpawnRange = 4;
    @Setting(value="world-enabled")
    @Comment(value="If 'true', this world will be registered.")
    private boolean worldEnabled = true;
    @Setting(value="serialization-behavior")
    @Comment(value="Determines how the server should save data for this world, if at all. Valid options are [automatic, manual, metadata_only, none].")
    private SerializationBehavior serializationBehavior = SerializationBehavior.AUTOMATIC;
    @Setting(value="load-on-startup")
    @Comment(value="If 'true', this world will load on startup.")
    private Boolean loadOnStartup = true;
    @Setting(value="generate-spawn-on-load")
    @Comment(value="If 'true', this world will generate its spawn the moment its loaded.")
    private Boolean generateSpawnOnLoad = false;
    @Setting(value="keep-spawn-loaded")
    @Comment(value="If 'true', this worlds spawn will remain loaded with no players.")
    private Boolean keepSpawnLoaded = false;
    @Setting(value="pvp-enabled")
    @Comment(value="If 'true', this world will allow PVP combat.")
    private boolean pvpEnabled = true;
    @Setting(value="chunk-gc-tick-interval")
    @Comment(value="The tick interval used to cleanup all inactive chunks that have leaked in a world. \nSet to 0 to disable which restores vanilla handling. (Default: 600)")
    private int chunkGCTickInterval = 600;
    @Setting(value="max-chunk-unloads-per-tick")
    @Comment(value="The maximum number of queued unloaded chunks that will be unloaded in a single tick. \nNote: With the chunk gc enabled, this setting only applies to the ticks \nwhere the gc runs (controlled by 'chunk-gc-tick-interval') \nNote: If the maximum unloads is too low, too many chunks may remain \nloaded on the world and increases the chance for a drop in tps. (Default: 100)")
    private int maxChunkUnloads = 100;
    @Setting(value="chunk-gc-load-threshold")
    @Comment(value="The number of newly loaded chunks before triggering a forced cleanup. \nNote: When triggered, the loaded chunk threshold will reset and start incrementing. \nDisabled by default.")
    private int chunkGCLoadThreshold = 0;
    @Setting(value="chunk-unload-delay")
    @Comment(value="The number of seconds to delay a chunk unload once marked inactive. (Default: 15) \nNote: This gets reset if the chunk becomes active again.")
    private int chunkUnloadDelay = 15;
    @Setting(value="item-merge-radius")
    @Comment(value="The defined merge radius for Item entities such that when two items are \nwithin the defined radius of each other, they will attempt to merge. Usually, \nthe default radius is set to 0.5 in Vanilla, however, for performance reasons \n2.5 is generally acceptable. \nNote: Increasing the radius higher will likely cause performance degradation \nwith larger amount of items as they attempt to merge and search nearby \nareas for more items. Setting to a negative value is not supported!")
    private double itemMergeRadius = 2.5;
    @Setting(value="weather-thunder")
    @Comment(value="If 'true', thunderstorms will be initiated in supported biomes.")
    private boolean weatherThunder = true;
    @Setting(value="weather-ice-and-snow")
    @Comment(value="If 'true', natural formation of ice and snow in supported biomes will be allowed.")
    private boolean weatherIceAndSnow = true;
    @Setting(value="generate-bonus-chest")
    @Comment(value="If 'true', the bonus chest will be generated near spawn")
    private boolean generateBonusChest = false;
    public static final int USE_SERVER_VIEW_DISTANCE = -1;
    @Setting(value="view-distance")
    @Comment(value="Override world distance per world/dimension \nThe value must be greater than or equal to 3 and less than or equal to 32 \nThe server-wide view distance will be used when the value is -1.")
    private int viewDistance = -1;

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public boolean isWorldEnabled() {
        return this.worldEnabled;
    }

    public void setWorldEnabled(boolean enabled) {
        this.worldEnabled = enabled;
    }

    public SerializationBehavior getSerializationBehavior() {
        return this.serializationBehavior;
    }

    public void setSerializationBehavior(SerializationBehavior serializationBehavior) {
        this.serializationBehavior = serializationBehavior;
    }

    public long getChunkUnloadDelay() {
        return this.chunkUnloadDelay;
    }

    public void setChunkUnloadDelay(int delay) {
        this.chunkUnloadDelay = delay;
    }

    public Boolean getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(Boolean state) {
        this.loadOnStartup = state;
    }

    public Boolean getKeepSpawnLoaded() {
        return this.keepSpawnLoaded;
    }

    public void setKeepSpawnLoaded(Boolean loaded) {
        this.keepSpawnLoaded = loaded;
    }

    public boolean getPVPEnabled() {
        return this.pvpEnabled;
    }

    public void setPVPEnabled(boolean allow) {
        this.pvpEnabled = allow;
    }

    public Boolean getGenerateSpawnOnLoad() {
        return this.generateSpawnOnLoad;
    }

    public void setGenerateSpawnOnLoad(Boolean allow) {
        this.generateSpawnOnLoad = allow;
    }

    public int getMobSpawnRange() {
        return this.mobSpawnRange;
    }

    public void setMobSpawnRange(int range) {
        this.mobSpawnRange = range;
    }

    public int getTickInterval() {
        return this.chunkGCTickInterval;
    }

    public int getChunkLoadThreshold() {
        return this.chunkGCLoadThreshold;
    }

    public int getMaxChunkUnloads() {
        return this.maxChunkUnloads;
    }

    public double getItemMergeRadius() {
        return this.itemMergeRadius;
    }

    public boolean getWeatherThunder() {
        return this.weatherThunder;
    }

    public boolean getWeatherIceAndSnow() {
        return this.weatherIceAndSnow;
    }

    public boolean getGenerateBonusChest() {
        return this.generateBonusChest;
    }

    public void setGenerateBonusChest(boolean state) {
        this.generateBonusChest = state;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }
}

