/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.Archetype;
import org.spongepowered.api.world.LocatableSnapshot;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;

public abstract class AbstractArchetype<C extends CatalogType, S extends LocatableSnapshot<S>, E>
implements Archetype<S, E>,
SpongeMutableDataHolder {
    protected final C type;
    protected CompoundNBT data;

    protected AbstractArchetype(C type, CompoundNBT data) {
        this.type = type;
        this.data = data;
    }

    public abstract DataProviderLookup getLookup();

    @Override
    public <V extends Value<E>, E> DataProvider<V, E> getProviderFor(Key<V> key) {
        return this.getLookup().getProvider(key);
    }

    @Override
    public Collection<DataProvider<?, ?>> getAllProviders() {
        return this.getLookup().getAllProviders();
    }

    protected abstract ValidationType getValidationType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractArchetype)) {
            return false;
        }
        AbstractArchetype that = (AbstractArchetype)o;
        return this.type.equals(that.type) && this.data.equals((Object)that.data);
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container, (Object)"Raw data cannot be null!");
        CompoundNBT copy = NbtTranslator.getInstance().translate(container);
        boolean valid = this.getValidator().validate(copy);
        if (!valid) {
            throw new InvalidDataException("Invalid data for " + this.getValidationType().getKey());
        }
        this.data = copy;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return this.getValidator().validate(container);
    }

    private DelegateDataValidator getValidator() {
        return new DelegateDataValidator(this.getValidators(), this.getValidationType());
    }

    protected abstract ImmutableList<RawDataValidator> getValidators();

    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", this.type).add("data", (Object)this.data).toString();
    }

    public CompoundNBT getCompound() {
        return this.data;
    }
}

