/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.meta;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.common.data.meta.SpongePatternLayer;
import org.spongepowered.common.util.Constants;

public class SpongePatternLayerBuilder
extends AbstractDataBuilder<BannerPatternLayer>
implements BannerPatternLayer.Builder,
DataBuilder<BannerPatternLayer> {
    private DyeColor color;
    private BannerPatternShape shape;

    public SpongePatternLayerBuilder() {
        super(BannerPatternLayer.class, 1);
    }

    @Override
    protected Optional<BannerPatternLayer> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (!container.contains(Constants.TileEntity.Banner.SHAPE) || !container.contains(Constants.TileEntity.Banner.COLOR)) {
            return Optional.empty();
        }
        BannerPatternShape shape = container.getCatalogType(Constants.TileEntity.Banner.SHAPE, BannerPatternShape.class).orElseThrow(() -> new InvalidDataException("The provided container has an invalid banner pattern shape entry!"));
        DyeColor color = container.getCatalogType(Constants.TileEntity.Banner.COLOR, DyeColor.class).orElseThrow(() -> new InvalidDataException("The provided container has an invalid dye color entry!"));
        return Optional.of(new SpongePatternLayer(shape, color));
    }

    @Override
    public SpongePatternLayerBuilder reset() {
        this.shape = null;
        this.color = null;
        return this;
    }

    @Override
    public BannerPatternLayer.Builder pattern(BannerPatternShape shape) {
        this.shape = (BannerPatternShape)Preconditions.checkNotNull((Object)shape);
        return this;
    }

    @Override
    public BannerPatternLayer.Builder color(DyeColor color) {
        this.color = (DyeColor)Preconditions.checkNotNull((Object)color);
        return this;
    }

    @Override
    public BannerPatternLayer.Builder from(BannerPatternLayer value) {
        this.shape = value.getShape();
        this.color = value.getColor();
        return this;
    }

    @Override
    public BannerPatternLayer build() {
        Preconditions.checkState((this.shape != null ? 1 : 0) != 0);
        Preconditions.checkState((this.color != null ? 1 : 0) != 0);
        return new SpongePatternLayer(this.shape, this.color);
    }
}

