/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormat;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataFormatException;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.data.persistence.NbtTranslator;

public class NbtDataFormat
extends SpongeCatalogType
implements DataFormat {
    public NbtDataFormat(ResourceKey key) {
        super(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataContainer readFrom(InputStream input) throws InvalidDataFormatException, IOException {
        try (DataInputStream dis = input instanceof DataInputStream ? (DataInputStream)input : new DataInputStream(input);){
            CompoundNBT tag = CompressedStreamTools.read((DataInputStream)dis);
            DataContainer dataContainer = NbtTranslator.getInstance().translateFrom(tag);
            return dataContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream output, DataView data) throws IOException {
        CompoundNBT tag = NbtTranslator.getInstance().translate(data);
        try (DataOutputStream dos = output instanceof DataOutputStream ? (DataOutputStream)output : new DataOutputStream(output);){
            CompressedStreamTools.write((CompoundNBT)tag, (DataOutput)dos);
        }
    }
}

