/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence.datastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.data.persistence.datastore.SpongeDataStore;
import org.spongepowered.common.util.Constants;
import org.spongepowered.configurate.util.Types;

public final class SpongeDataStoreBuilder
implements DataStore.Builder,
DataStore.Builder.HolderStep,
DataStore.Builder.SerializersStep,
DataStore.Builder.EndStep {
    private final Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>> serializers = new IdentityHashMap();
    private final List<Type> dataHolderTypes = new ArrayList<Type>();
    @Nullable
    private ResourceKey key;

    @Override
    public <T, V extends Value<T>> SpongeDataStoreBuilder key(Key<V> key, DataQuery dataQuery) {
        BiFunction deserializer = this.getDeserializer(key.getElementType());
        return this.key((Key)key, (T view, U value) -> view.set(dataQuery, value), (T v) -> (Optional)deserializer.apply((DataView)v, dataQuery));
    }

    public <T> BiFunction<DataView, DataQuery, Optional<T>> getDeserializer(Type elementType) {
        BiFunction<DataView, DataQuery, Optional<T>> deserializer;
        Class<?> rawType = GenericTypeReflector.erase(elementType);
        if (DataView.class.isAssignableFrom(rawType)) {
            deserializer = (view, dataQuery) -> view.getView((DataQuery)dataQuery);
        } else if (DataSerializable.class.isAssignableFrom(rawType)) {
            deserializer = (view, dataQuery) -> view.getSerializable((DataQuery)dataQuery, rawType);
        } else if (CatalogType.class.isAssignableFrom(rawType)) {
            deserializer = (view, dataQuery) -> view.getCatalogType((DataQuery)dataQuery, rawType);
        } else if (Sponge.getGame().getDataManager().getTranslator(rawType).isPresent()) {
            deserializer = (view, dataQuery) -> view.getObject((DataQuery)dataQuery, rawType);
        } else if (Set.class.isAssignableFrom(rawType)) {
            Type listType = ((ParameterizedType)elementType).getActualTypeArguments()[0];
            deserializer = (view, dataQuery) -> SpongeDataStoreBuilder.deserializeList((Class)listType, view, dataQuery).map(list -> new HashSet(list));
        } else if (List.class.isAssignableFrom(rawType)) {
            Type listType = ((ParameterizedType)elementType).getActualTypeArguments()[0];
            deserializer = (view, dataQuery) -> SpongeDataStoreBuilder.deserializeList((Class)listType, view, dataQuery);
        } else {
            if (Collection.class.isAssignableFrom(rawType)) {
                throw new UnsupportedOperationException("Collection deserialization is not supported. Provide the deserializer for it.");
            }
            if (Types.isArray(elementType)) {
                Class<?> arrayType = GenericTypeReflector.erase(GenericTypeReflector.getArrayComponentType(elementType));
                deserializer = (view, dataQuery) -> SpongeDataStoreBuilder.deserializeList(arrayType, view, dataQuery).map(list -> this.listToArray(arrayType, (List)list));
            } else if (Map.class.isAssignableFrom(rawType)) {
                Function<DataQuery, Optional> keyDeserializer;
                Type[] parameterTypes = ((ParameterizedType)elementType).getActualTypeArguments();
                Type keyType = parameterTypes[0];
                Type valueType = parameterTypes[1];
                if (!(keyType instanceof Class)) {
                    throw new UnsupportedOperationException("Unsupported map-key type " + keyType);
                }
                if (((Class)keyType).isAssignableFrom(CatalogType.class)) {
                    keyDeserializer = key -> Sponge.getRegistry().getCatalogRegistry().get((Class)keyType, ResourceKey.resolve(key.toString()));
                } else if (((Class)keyType).isEnum()) {
                    keyDeserializer = key -> Optional.ofNullable(Enum.valueOf((Class)keyType, key.toString()));
                } else if (keyType == String.class) {
                    keyDeserializer = key -> Optional.of(key.toString());
                } else if (keyType == UUID.class) {
                    keyDeserializer = key -> Optional.of(key.toString());
                } else {
                    throw new UnsupportedOperationException("Unsupported map-key type " + keyType);
                }
                BiFunction valueDeserializer = this.getDeserializer(valueType);
                deserializer = (view, dataQuery) -> view.getView((DataQuery)dataQuery).map(mapView -> {
                    HashMap resultMap = new HashMap();
                    for (DataQuery key : mapView.getKeys(false)) {
                        Object mapKey = ((Optional)keyDeserializer.apply(key)).orElseThrow(() -> new UnsupportedOperationException("Key not found " + key + " as " + keyType));
                        Optional mapValue = (Optional)valueDeserializer.apply((DataView)mapView, key);
                        resultMap.put(mapKey, mapValue.get());
                    }
                    return resultMap;
                });
            } else {
                deserializer = (view, dataQuery) -> view.get((DataQuery)dataQuery);
            }
        }
        return deserializer;
    }

    private static <T> Optional<List<T>> deserializeList(Class<T> listType, DataView view, DataQuery dataQuery) {
        if (DataView.class.isAssignableFrom(listType)) {
            return view.getViewList(dataQuery);
        }
        if (DataSerializable.class.isAssignableFrom(listType)) {
            return view.getSerializableList(dataQuery, listType);
        }
        if (CatalogType.class.isAssignableFrom(listType)) {
            return view.getCatalogTypeList(dataQuery, listType);
        }
        if (Sponge.getGame().getDataManager().getTranslator(listType).isPresent()) {
            return view.getObjectList(dataQuery, listType);
        }
        return view.getList(dataQuery);
    }

    private <AT> AT[] listToArray(Class<AT> componentType, List<AT> list) {
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    public boolean isEmpty() {
        return this.serializers.isEmpty();
    }

    public List<Type> getDataHolderTypes() {
        return this.dataHolderTypes;
    }

    @Override
    public <T, V extends Value<T>> SpongeDataStoreBuilder key(Key<V> key, BiConsumer<DataView, T> serializer, Function<DataView, Optional<T>> deserializer) {
        if (this.key != null) {
            this.serializers.put(key, Tuple.of(new CustomDataSerializer<T>(serializer, this.key.toString()), new CustomDataDeserializer<T>(deserializer, this.key.toString())));
        } else {
            this.serializers.put(key, Tuple.of(serializer, deserializer));
        }
        return this;
    }

    @Override
    public DataStore.Builder reset() {
        this.serializers.clear();
        this.dataHolderTypes.clear();
        this.key = null;
        return this;
    }

    @Override
    public SpongeDataStoreBuilder holder(TypeToken<? extends DataHolder> ... typeTokens) {
        for (TypeToken<? extends DataHolder> token : typeTokens) {
            this.dataHolderTypes.add(token.getType());
        }
        return this;
    }

    @Override
    public SpongeDataStoreBuilder holder(Class<? extends DataHolder> ... classes) {
        for (Class<? extends DataHolder> clazz : classes) {
            this.dataHolderTypes.add(Types.requireCompleteParameters(clazz));
        }
        return this;
    }

    @Override
    public SpongeDataStoreBuilder pluginData(ResourceKey key) {
        this.key = key;
        return this;
    }

    @Override
    public SpongeDataStoreBuilder vanillaData() {
        this.key = null;
        return this;
    }

    @Override
    public DataStore build() {
        return new SpongeDataStore((Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>>)ImmutableMap.copyOf(this.serializers), (Collection<Type>)ImmutableList.copyOf(this.dataHolderTypes));
    }

    public DataStore buildVanillaDataStore() {
        return new SpongeDataStore(Collections.unmodifiableMap(this.serializers), this.dataHolderTypes);
    }

    private static class CustomDataDeserializer<T>
    implements Function<DataView, Optional<T>> {
        private final Function<DataView, Optional<T>> deserializer;
        private final String key;

        public CustomDataDeserializer(Function<DataView, Optional<T>> deserializer, String key) {
            this.deserializer = deserializer;
            this.key = key;
        }

        @Override
        public Optional<T> apply(DataView view) {
            return view.getView(Constants.Forge.ROOT).flatMap(v -> v.getView(Constants.Sponge.SPONGE_ROOT)).flatMap(v -> v.getViewList(Constants.Sponge.CUSTOM_MANIPULATOR_LIST)).flatMap(manipulators -> manipulators.stream().filter(v -> v.getString(Constants.Sponge.DATA_ID).map(id -> id.equals(this.key.toString())).orElse(false)).findFirst().map(v -> v.getView(Constants.Sponge.MANIPULATOR_DATA).orElse(DataContainer.createNew())).flatMap(this.deserializer));
        }
    }

    private static class CustomDataSerializer<T>
    implements BiConsumer<DataView, T> {
        private final BiConsumer<DataView, T> serializer;
        private final String key;

        public CustomDataSerializer(BiConsumer<DataView, T> serializer, String key) {
            this.serializer = serializer;
            this.key = key;
        }

        @Override
        public void accept(DataView view, T v) {
            DataView manipulatorContainer;
            Optional<DataView> existingContainer;
            DataContainer internalData = DataContainer.createNew();
            this.serializer.accept(internalData, (DataView)v);
            if (internalData.isEmpty()) {
                return;
            }
            DataView forgeData = view.getView(Constants.Forge.ROOT).orElseGet(() -> view.createView(Constants.Forge.ROOT));
            DataView spongeData = forgeData.getView(Constants.Sponge.SPONGE_ROOT).orElseGet(() -> forgeData.createView(Constants.Sponge.SPONGE_ROOT));
            ArrayList<DataView> viewList = spongeData.getViewList(Constants.Sponge.CUSTOM_MANIPULATOR_LIST).orElse(null);
            if (viewList == null) {
                viewList = new ArrayList<DataView>();
                spongeData.set(Constants.Sponge.CUSTOM_MANIPULATOR_LIST, viewList);
            }
            if ((existingContainer = viewList.stream().filter(potentialContainer -> potentialContainer.getString(Constants.Sponge.DATA_ID).map(id -> id.equals(this.key)).orElse(false)).findFirst()).isPresent()) {
                manipulatorContainer = existingContainer.get();
            } else {
                manipulatorContainer = DataContainer.createNew();
                viewList.add(manipulatorContainer);
            }
            manipulatorContainer.set(Queries.CONTENT_VERSION, 2).set(Constants.Sponge.DATA_ID, this.key).set(Constants.Sponge.MANIPULATOR_DATA, internalData);
            spongeData.set(Constants.Sponge.CUSTOM_MANIPULATOR_LIST, viewList);
        }
    }
}

