/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import com.google.common.collect.ImmutableList;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.accessor.entity.item.FireworkRocketEntityAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.FireworkUtil;
import org.spongepowered.common.util.SpongeTicks;

public final class FireworkRocketData {
    private FireworkRocketData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(FireworkRocketEntity.class).create(Keys.FIREWORK_EFFECTS).get(h2 -> FireworkUtil.getFireworkEffects(h2).orElse(null))).set(FireworkUtil::setFireworkEffects)).resetOnDelete(ImmutableList.of())).create(Keys.FIREWORK_FLIGHT_MODIFIER).get(h2 -> {
            ItemStack item = FireworkUtil.getItem(h2);
            CompoundNBT fireworks = item.getOrCreateChildTag("Fireworks");
            if (fireworks.contains("Flight")) {
                return new SpongeTicks(fireworks.getByte("Flight"));
            }
            return null;
        })).setAnd((h2, v) -> {
            int ticks = (int)v.getTicks();
            if (ticks < 0 || ticks > 127) {
                return false;
            }
            ItemStack item = FireworkUtil.getItem(h2);
            CompoundNBT fireworks = item.getOrCreateChildTag("Fireworks");
            fireworks.putByte("Flight", (byte)ticks);
            ((FireworkRocketEntityAccessor)h2).accessor$setLifeTime(10 * ticks + ((EntityAccessor)h2).accessor$getRand().nextInt(6) + ((EntityAccessor)h2).accessor$getRand().nextInt(7));
            return true;
        });
    }
}

