/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.NestedTableEntry;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.accessor.item.ToolItemAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class ItemStackData {
    private ItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.APPLICABLE_POTION_EFFECTS).get(h2 -> {
            if (h2.isFood()) {
                List itemEffects = h2.getItem().getFood().getEffects();
                WeightedTable effects = new WeightedTable();
                ChanceTable<PotionEffect> chance = new ChanceTable<PotionEffect>();
                for (Pair effect : itemEffects) {
                    chance.add((PotionEffect)effect.getKey(), ((Float)effect.getValue()).floatValue());
                }
                effects.add(new NestedTableEntry(1.0, chance));
                return effects;
            }
            return null;
        })).create(Keys.BURN_TIME).get(h2 -> {
            Integer burnTime = (Integer)AbstractFurnaceTileEntity.getBurnTimes().get(h2.getItem());
            if (burnTime != null && burnTime > 0) {
                return burnTime;
            }
            return null;
        })).create(Keys.CAN_HARVEST).get(h2 -> {
            Item item = h2.getItem();
            if (item instanceof ToolItemAccessor && !(item instanceof PickaxeItem)) {
                Set<Block> blocks = ((ToolItemAccessor)item).accessor$getEffectiveBlocks();
                return ImmutableSet.copyOf(blocks);
            }
            Set blockTypes = (Set)Registry.BLOCK.stream().filter(b -> item.canHarvestBlock(b.getDefaultState())).map(BlockType.class::cast).collect(ImmutableSet.toImmutableSet());
            return blockTypes.isEmpty() ? null : blockTypes;
        })).create(Keys.CONTAINER_ITEM).get(h2 -> (ItemType)h2.getItem().getContainerItem())).create(Keys.DISPLAY_NAME).get(h2 -> {
            CompoundNBT tag;
            if (h2.getItem() == Items.WRITTEN_BOOK && (tag = h2.getTag()) != null) {
                String title = tag.getString("title");
                return SpongeAdventure.legacySection(title);
            }
            return SpongeAdventure.asAdventure(h2.getDisplayName());
        })).setAnd((h2, v) -> {
            if (h2.getItem() == Items.WRITTEN_BOOK) {
                String legacy = SpongeAdventure.legacySection(v);
                h2.setTagInfo("title", (INBT)StringNBT.valueOf((String)legacy));
                return true;
            }
            return false;
        })).create(Keys.CUSTOM_MODEL_DATA).get(h2 -> {
            CompoundNBT tag = h2.getTag();
            if (tag == null || !tag.contains("CustomModelData", 3)) {
                return null;
            }
            return tag.getInt("CustomModelData");
        })).set((h2, v) -> {
            CompoundNBT tag = h2.getOrCreateTag();
            tag.putInt("CustomModelData", v.intValue());
        })).delete(h2 -> {
            CompoundNBT tag = h2.getTag();
            if (tag != null) {
                tag.remove("CustomModelData");
            }
        })).create(Keys.CUSTOM_NAME).get(h2 -> h2.hasDisplayName() ? SpongeAdventure.asAdventure(h2.getDisplayName()) : null)).set((h2, v) -> h2.setDisplayName(SpongeAdventure.asVanilla(v)))).delete(ItemStack::clearCustomName)).create(Keys.IS_UNBREAKABLE).get(h2 -> {
            CompoundNBT tag = h2.getTag();
            if (tag == null || !tag.contains("Unbreakable", 1)) {
                return false;
            }
            return tag.getBoolean("Unbreakable");
        })).set(ItemStackData::setIsUnbrekable)).delete(h2 -> ItemStackData.setIsUnbrekable(h2, false))).create(Keys.LORE).get(h2 -> {
            CompoundNBT tag = h2.getTag();
            if (tag == null || tag.contains("display")) {
                return null;
            }
            ListNBT list = tag.getList("Lore", 8);
            return list.isEmpty() ? null : SpongeAdventure.json(list.stream().collect(NBTCollectors.toStringList()));
        })).set((h2, v) -> {
            if (v.isEmpty()) {
                ItemStackData.deleteLore(h2);
                return;
            }
            ListNBT list = SpongeAdventure.listTagJson(v);
            h2.getOrCreateChildTag("display").put("Lore", (INBT)list);
        })).delete(ItemStackData::deleteLore)).create(Keys.MAX_DURABILITY).get(h2 -> h2.getItem().isDamageable() ? Integer.valueOf(h2.getItem().getMaxDamage()) : null)).supports(h2 -> h2.getItem().isDamageable())).create(Keys.ITEM_DURABILITY).get(stack -> stack.getMaxDamage() - stack.getDamage())).set((stack, durability) -> stack.setDamage(stack.getMaxDamage() - durability))).supports(h2 -> h2.getItem().isDamageable())).create(Keys.REPLENISHED_FOOD).get(h2 -> {
            if (h2.getItem().isFood()) {
                Food food = h2.getItem().getFood();
                return food == null ? null : Integer.valueOf(food.getHealing());
            }
            return null;
        })).supports(h2 -> h2.getItem().isFood())).create(Keys.REPLENISHED_SATURATION).get(h2 -> {
            Food food;
            if (h2.getItem().isFood() && (food = h2.getItem().getFood()) != null) {
                return (double)(food.getSaturation() * (float)food.getHealing()) * 2.0;
            }
            return null;
        })).supports(h2 -> h2.getItem().isFood());
    }

    private static void setIsUnbrekable(ItemStack stack, Boolean value) {
        if (value == null || !value.booleanValue() && !stack.hasTag()) {
            return;
        }
        CompoundNBT tag = stack.getOrCreateTag();
        if (value.booleanValue()) {
            tag.putBoolean("Unbreakable", true);
        } else {
            tag.remove("Unbreakable");
        }
    }

    private static void deleteLore(ItemStack stack) {
        CompoundNBT tag = stack.getTag();
        if (tag != null && tag.contains("display")) {
            tag.getCompound("display").remove("Lore");
        }
    }
}

