/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.entity.LivingEntityAccessor;
import org.spongepowered.common.accessor.entity.player.ServerPlayerEntityAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.world.PlatformServerWorldBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.DimensionChangeResult;
import org.spongepowered.common.world.portal.PortalHelper;
import org.spongepowered.common.world.portal.WrappedITeleporterPortalType;
import org.spongepowered.math.vector.Vector3d;

public final class EntityUtil {
    public static final Function<PhaseContext<?>, Supplier<Optional<User>>> ENTITY_CREATOR_FUNCTION = context -> () -> Stream.builder().add(() -> context.getSource(User.class)).add(context::getNotifier).add(context::getCreator).build().map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();

    private EntityUtil() {
    }

    public static DimensionChangeResult<net.minecraft.entity.Entity> invokePortalTo(net.minecraft.entity.Entity entity, PortalType portal, DimensionType dimensionType) {
        net.minecraft.world.server.ServerWorld originalToWorld;
        net.minecraft.world.server.ServerWorld toWorld = originalToWorld = entity.getServer().getWorld(dimensionType);
        ChangeEntityWorldEvent.Pre event = PlatformHooks.getInstance().getEventHooks().callChangeEntityWorldEventPre(entity, toWorld);
        if (event == null || event.isCancelled() || ((WorldBridge)((Object)event.getDestinationWorld())).bridge$isFake()) {
            return new DimensionChangeResult<net.minecraft.entity.Entity>(entity, false, false);
        }
        toWorld = (net.minecraft.world.server.ServerWorld)event.getDestinationWorld();
        ServerLocation previousLocation = ((Entity)entity).getServerLocation();
        net.minecraft.world.server.ServerWorld fromWorld = (net.minecraft.world.server.ServerWorld)entity.getEntityWorld();
        net.minecraft.entity.Entity result = entity;
        if (portal instanceof WrappedITeleporterPortalType) {
            result = ((WrappedITeleporterPortalType)portal).getTeleporter().bridge$placeEntity(entity, fromWorld, toWorld, entity.rotationYaw, PortalHelper.createVanillaEntityPortalLogic(entity, entity.getPositionVec(), fromWorld, toWorld, portal));
            if (result == null) {
                return new DimensionChangeResult<net.minecraft.entity.Entity>(entity, false, true);
            }
            ServerLocation currentLocation = ((Entity)entity).getServerLocation();
            if (previousLocation.getWorld() == currentLocation.getWorld() && previousLocation.getBlockPosition().equals((Object)currentLocation.getBlockPosition())) {
                return new DimensionChangeResult<net.minecraft.entity.Entity>(entity, false, false);
            }
        } else if (!portal.teleport((Entity)entity, ServerLocation.of((ServerWorld)fromWorld, VecHelper.toVector3d(entity.getPositionVector())), true)) {
            return new DimensionChangeResult<net.minecraft.entity.Entity>(entity, false, false);
        }
        PlatformHooks.getInstance().getEventHooks().callChangeEntityWorldEventPost(result, fromWorld, originalToWorld);
        return new DimensionChangeResult<net.minecraft.entity.Entity>(result, true, false);
    }

    public static DimensionChangeResult<ServerPlayerEntity> invokePortalTo(ServerPlayerEntity player, PortalType portal, DimensionType dimensionType) {
        boolean isVanillaPortal;
        net.minecraft.world.server.ServerWorld originalToWorld;
        net.minecraft.world.server.ServerWorld toWorld = originalToWorld = player.getServer().getWorld(dimensionType);
        ChangeEntityWorldEvent.Pre event = PlatformHooks.getInstance().getEventHooks().callChangeEntityWorldEventPre((net.minecraft.entity.Entity)player, toWorld);
        if (event == null || event.isCancelled()) {
            return new DimensionChangeResult<ServerPlayerEntity>(player, false, false);
        }
        toWorld = (net.minecraft.world.server.ServerWorld)event.getDestinationWorld();
        ((ServerPlayerEntityAccessor)player).accessor$setInvulnerableDimensionChange(true);
        ServerLocation previousLocation = ((ServerPlayer)player).getServerLocation();
        net.minecraft.world.server.ServerWorld fromWorld = player.getServerWorld();
        DimensionType fromDimensionType = fromWorld.getDimension().getType();
        if (portal instanceof WrappedITeleporterPortalType) {
            ((WrappedITeleporterPortalType)portal).getTeleporter().bridge$placeEntity((net.minecraft.entity.Entity)player, fromWorld, toWorld, player.rotationYaw, PortalHelper.createVanillaPlayerPortalLogic(player, player.getPositionVec(), fromWorld, toWorld, portal));
            ServerLocation currentLocation = ((ServerPlayer)player).getServerLocation();
            if (previousLocation.getWorld() == currentLocation.getWorld() && previousLocation.getBlockPosition().equals((Object)currentLocation.getBlockPosition())) {
                return new DimensionChangeResult<ServerPlayerEntity>(player, false, false);
            }
        } else if (!portal.teleport((Entity)player, ServerLocation.of((ServerWorld)fromWorld, VecHelper.toVector3d(player.getPositionVector())), true)) {
            return new DimensionChangeResult<ServerPlayerEntity>(player, false, false);
        }
        boolean bl = isVanillaPortal = portal instanceof WrappedITeleporterPortalType && ((WrappedITeleporterPortalType)portal).getTeleporter().bridge$isVanilla();
        if (fromDimensionType == DimensionType.THE_END && toWorld.getDimension().getType() == DimensionType.OVERWORLD && isVanillaPortal) {
            player.detach();
            player.getServerWorld().removePlayer(player);
            if (!player.queuedEndExit) {
                player.queuedEndExit = true;
                player.connection.sendPacket((IPacket)new SChangeGameStatePacket(4, ((ServerPlayerEntityAccessor)player).accessor$getSeenCredits() ? 0.0f : 1.0f));
                ((ServerPlayerEntityAccessor)player).accessor$setSeenCredits(true);
            }
            return new DimensionChangeResult<ServerPlayerEntity>(player, true, false);
        }
        EntityUtil.performPostChangePlayerWorldLogic(player, fromWorld, originalToWorld, toWorld, true);
        return new DimensionChangeResult<ServerPlayerEntity>(player, true, false);
    }

    public static void performPostChangePlayerWorldLogic(ServerPlayerEntity player, net.minecraft.world.server.ServerWorld fromWorld, net.minecraft.world.server.ServerWorld originalToWorld, net.minecraft.world.server.ServerWorld toWorld, boolean isPortal) {
        ((ServerPlayerEntityBridge)player).bridge$sendDimensionData(player.connection.netManager, toWorld.dimension.getType());
        WorldInfo worldinfo = toWorld.getWorldInfo();
        if (!isPortal) {
            ((ServerPlayerEntityBridge)player).bridge$sendChangeDimension(toWorld.dimension.getType(), WorldInfo.byHashing((long)worldinfo.getSeed()), worldinfo.getGenerator(), player.interactionManager.getGameType());
        }
        player.dimension = toWorld.dimension.getType();
        player.connection.sendPacket((IPacket)new SServerDifficultyPacket(worldinfo.getDifficulty(), worldinfo.isDifficultyLocked()));
        PlayerList playerlist = player.getServer().getPlayerList();
        playerlist.updatePermissionLevel(player);
        ((PlatformServerWorldBridge)fromWorld).bridge$removeEntity((net.minecraft.entity.Entity)player, true);
        ((PlatformEntityBridge)player).bridge$revive();
        player.setWorld((World)toWorld);
        toWorld.addRespawnedPlayer(player);
        if (isPortal) {
            ((ServerPlayerEntityAccessor)player).accessor$func_213846_b(toWorld);
        }
        player.interactionManager.setWorld(toWorld);
        player.connection.sendPacket((IPacket)new SPlayerAbilitiesPacket(player.abilities));
        playerlist.sendWorldInfo(player, toWorld);
        playerlist.sendInventory(player);
        for (EffectInstance effectinstance : player.getActivePotionEffects()) {
            player.connection.sendPacket((IPacket)new SPlayEntityEffectPacket(player.getEntityId(), effectinstance));
        }
        if (isPortal) {
            player.connection.sendPacket((IPacket)new SPlaySoundEventPacket(1032, BlockPos.ZERO, 0, false));
        }
        ((ServerWorldBridge)fromWorld).bridge$getBossBarManager().onPlayerLogout(player);
        ((ServerWorldBridge)toWorld).bridge$getBossBarManager().onPlayerLogin(player);
        ((ServerPlayerEntityAccessor)player).accessor$setLastExperience(-1);
        ((ServerPlayerEntityAccessor)player).accessor$setLastHealth(-1.0f);
        ((ServerPlayerEntityAccessor)player).accessor$setLastFoodLevel(-1);
        if (!isPortal) {
            player.connection.setPlayerLocation(player.getPosX(), player.getPosY(), player.getPosZ(), player.rotationYaw, player.rotationPitch);
            player.connection.captureCurrentPosition();
        }
        if (player.openContainer != player.container) {
            player.closeContainer();
        }
        PlatformHooks.getInstance().getEventHooks().callChangeEntityWorldEventPost((net.minecraft.entity.Entity)player, fromWorld, originalToWorld);
    }

    public static boolean isEntityDead(net.minecraft.entity.Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity base = (LivingEntity)entity;
            return base.getHealth() <= 0.0f || base.deathTime > 0 || ((LivingEntityAccessor)entity).accessor$getDead();
        }
        return entity.removed;
    }

    public static boolean processEntitySpawnsFromEvent(SpawnEntityEvent event, Supplier<Optional<User>> entityCreatorSupplier) {
        boolean spawnedAny = false;
        for (Entity entity : event.getEntities()) {
            spawnedAny = EntityUtil.processEntitySpawn(entity, entityCreatorSupplier);
        }
        return spawnedAny;
    }

    public static boolean processEntitySpawnsFromEvent(PhaseContext<?> context, SpawnEntityEvent destruct) {
        return EntityUtil.processEntitySpawnsFromEvent(destruct, ENTITY_CREATOR_FUNCTION.apply(context));
    }

    public static boolean processEntitySpawn(Entity entity, Supplier<Optional<User>> supplier) {
        Optional<net.minecraft.entity.Entity> customEntityItem;
        ItemStack item;
        net.minecraft.entity.Entity minecraftEntity = (net.minecraft.entity.Entity)entity;
        if (minecraftEntity instanceof ItemEntity && !(item = ((ItemEntity)minecraftEntity).getItem()).isEmpty() && (customEntityItem = Optional.ofNullable(SpongeImplHooks.getCustomEntityIfItem(minecraftEntity))).isPresent()) {
            net.minecraft.entity.Entity entityToSpawn = customEntityItem.get();
            supplier.get().ifPresent(spawned -> {
                if (entityToSpawn instanceof CreatorTrackedBridge) {
                    ((CreatorTrackedBridge)entityToSpawn).tracked$setCreatorReference((User)spawned);
                }
            });
            if (entityToSpawn.removed) {
                entityToSpawn.removed = false;
            }
            entityToSpawn.world.addEntity(entityToSpawn);
            return true;
        }
        supplier.get().ifPresent(spawned -> {
            if (entity instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)((Object)entity)).tracked$setCreatorReference((User)spawned);
            }
        });
        ((World)entity.getWorld()).addEntity((net.minecraft.entity.Entity)entity);
        return true;
    }

    private static Vector3d createDropMotion(boolean dropAround, PlayerEntity player, Random random) {
        double y;
        double z;
        double x;
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            x = -MathHelper.sin((float)f1) * f;
            z = MathHelper.cos((float)f1) * f;
            y = 0.2f;
        } else {
            float f2 = 0.3f;
            x = -MathHelper.sin((float)(player.rotationYaw * ((float)Math.PI / 180))) * MathHelper.cos((float)(player.rotationPitch * ((float)Math.PI / 180))) * f2;
            z = MathHelper.cos((float)(player.rotationYaw * ((float)Math.PI / 180))) * MathHelper.cos((float)(player.rotationPitch * ((float)Math.PI / 180))) * f2;
            y = -MathHelper.sin((float)(player.rotationPitch * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = random.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * random.nextFloat();
            x += Math.cos(f3) * (double)f2;
            y += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
            z += Math.sin(f3) * (double)f2;
        }
        return new Vector3d(x, y, z);
    }

    public static boolean isUntargetable(net.minecraft.entity.Entity from, net.minecraft.entity.Entity target) {
        if (((VanishableBridge)target).bridge$isVanished() && ((VanishableBridge)target).bridge$isUntargetable()) {
            return true;
        }
        return from.world != target.world;
    }
}

