/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai;

import com.google.common.base.Preconditions;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.LookAtGoal;
import org.spongepowered.api.entity.ai.goal.builtin.LookAtGoal;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;

public final class SpongeWatchClosestAIBuilder
implements LookAtGoal.Builder {
    private Class<? extends Living> watchedClass;
    private float maxDistance;
    private float chance;

    public SpongeWatchClosestAIBuilder() {
        this.reset();
    }

    @Override
    public LookAtGoal.Builder watch(Class<? extends Living> watchedClass) {
        this.watchedClass = watchedClass;
        return this;
    }

    @Override
    public LookAtGoal.Builder maxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
        return this;
    }

    @Override
    public LookAtGoal.Builder chance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public LookAtGoal.Builder from(org.spongepowered.api.entity.ai.goal.builtin.LookAtGoal value) {
        return this.watch(value.getWatchedClass()).maxDistance(value.getMaxDistance()).chance(value.getChance());
    }

    @Override
    public LookAtGoal.Builder reset() {
        this.watchedClass = null;
        this.maxDistance = 8.0f;
        this.chance = 0.02f;
        return this;
    }

    @Override
    public org.spongepowered.api.entity.ai.goal.builtin.LookAtGoal build(Agent owner) {
        Preconditions.checkNotNull(this.watchedClass);
        return (org.spongepowered.api.entity.ai.goal.builtin.LookAtGoal)new LookAtGoal((MobEntity)owner, this.watchedClass, this.maxDistance, this.chance);
    }
}

