/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.entity.UserInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.RespawnLocation;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.storage.SaveHandlerAccessor;
import org.spongepowered.common.bridge.authlib.GameProfileHolderBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.InvulnerableTrackedBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.player.BedLocationHolderBridge;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.entity.player.SpongeUserInventory;
import org.spongepowered.common.entity.player.SpongeUserInventoryEnderchest;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.service.server.permission.BridgeSubject;
import org.spongepowered.common.service.server.permission.SubjectHelper;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeUser
implements User,
DataSerializable,
BedLocationHolderBridge,
SpongeMutableDataHolder,
BridgeSubject,
SubjectBridge,
DataCompoundHolder,
InvulnerableTrackedBridge,
VanishableBridge,
GameProfileHolderBridge {
    public static final Set<SpongeUser> dirtyUsers = ConcurrentHashMap.newKeySet();
    public static final Set<SpongeUser> initializedUsers = ConcurrentHashMap.newKeySet();
    private final GameProfile profile;
    private final Map<ResourceKey, RespawnLocation> spawnLocations = Maps.newHashMap();
    private ResourceKey worldKey = SpongeWorldManager.VANILLA_OVERWORLD;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private boolean invulnerable;
    private boolean isVanished;
    private boolean isInvisible;
    private boolean isVanishCollide;
    private boolean isVanishTarget;
    @Nullable
    private SubjectReference subjectReference;
    @Nullable
    private SpongeUserInventory inventory;
    @Nullable
    private EnderChestInventory enderChest;
    @Nullable
    private CompoundNBT compound;
    private boolean isConstructing;

    public SpongeUser(GameProfile profile) {
        this.profile = profile;
        SubjectHelper.applySubject(this);
    }

    private void reset() {
        this.spawnLocations.clear();
    }

    public boolean isInitialized() {
        return this.compound != null;
    }

    @Override
    public DataHolder.Mutable delegateDataHolder() {
        return this.getDataHolder(true);
    }

    public DataHolder.Mutable getDataHolder(boolean markDirty) {
        if (this.isOnline()) {
            return this.getPlayer().get();
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        if (markDirty) {
            this.markDirty();
        }
        return this;
    }

    public void invalidate() {
        this.compound = null;
        this.inventory = null;
        this.enderChest = null;
        ((CustomDataHolderBridge)((Object)this)).bridge$getFailedData().clear();
        initializedUsers.remove(this);
    }

    public void initializeIfRequired() {
        if (!this.isInitialized()) {
            this.initialize();
        }
    }

    public void initialize() {
        initializedUsers.add(this);
        this.compound = new CompoundNBT();
        net.minecraft.world.server.ServerWorld world = ((SpongeWorldManager)Sponge.getServer().getWorldManager()).getDefaultWorld();
        if (world == null) {
            return;
        }
        SaveHandlerAccessor saveHandler = (SaveHandlerAccessor)world.getSaveHandler();
        File file = new File(saveHandler.accessor$getPlayersDirectory(), this.profile.getId().toString() + ".dat");
        if (!file.exists()) {
            return;
        }
        try (FileInputStream in = new FileInputStream(file);){
            this.readFromNBT(CompressedStreamTools.readCompressed((InputStream)in));
        }
        catch (IOException e) {
            SpongeCommon.getLogger().warn("Corrupt user file '{}'!", (Object)file, (Object)e);
        }
    }

    public void readFromNBT(CompoundNBT compound) {
        this.reset();
        this.compound = compound;
        if (!compound.contains("Key")) {
            DimensionType type;
            if (compound.contains("dimensionId") && (type = DimensionType.getById((int)compound.getInt("dimensionId"))) != null) {
                this.worldKey = (ResourceKey)Registry.DIMENSION_TYPE.getKey((Object)type);
            }
        } else {
            this.worldKey = ResourceKey.resolve(compound.getString("Key"));
        }
        ListNBT position = compound.getList("Pos", 6);
        ListNBT rotation = compound.getList("Rotation", 5);
        this.x = position.getDouble(0);
        this.y = position.getDouble(1);
        this.z = position.getDouble(2);
        this.yaw = rotation.getFloat(0);
        this.pitch = rotation.getFloat(1);
        this.invulnerable = compound.getBoolean("Invulnerable");
        CompoundNBT spongeCompound = compound.getCompound("ForgeData").getCompound("SpongeData");
        this.isConstructing = true;
        CustomDataHolderBridge.syncTagToCustom(this);
        this.isConstructing = false;
        if (spongeCompound.isEmpty()) {
            return;
        }
        this.isVanished = spongeCompound.getBoolean("IsVanished");
        this.isInvisible = spongeCompound.getBoolean("IsInvisible");
        if (this.isVanished) {
            this.isVanishTarget = spongeCompound.getBoolean("VanishUnTargetable");
            this.isVanishCollide = spongeCompound.getBoolean("VanishUnCollideable");
        }
        ListNBT spawns = spongeCompound.getList("Spawns", 10);
        for (int i = 0; i < spawns.size(); ++i) {
            CompoundNBT spawnCompound = spawns.getCompound(i);
            if (!spawnCompound.contains("Key")) continue;
            ResourceKey key = ResourceKey.resolve(spawnCompound.getString("Key"));
            double xPos = spawnCompound.getDouble("SpawnX");
            double yPos = spawnCompound.getDouble("SpawnY");
            double zPos = spawnCompound.getDouble("SpawnZ");
            boolean forced = spawnCompound.getBoolean("SpawnForced");
            this.spawnLocations.put(key, new RespawnLocation.Builder().world(key).position(new Vector3d(xPos, yPos, zPos)).forceSpawn(forced).build());
        }
    }

    private UserInventory loadInventory() {
        if (this.inventory == null) {
            if (!this.isInitialized()) {
                this.initialize();
            }
            this.inventory = new SpongeUserInventory(this);
            ListNBT listNBT = this.compound.getList("Inventory", 10);
            this.inventory.readFromNBT(listNBT);
            this.inventory.currentItem = this.compound.getInt("SelectedItemSlot");
        }
        return (UserInventory)((Object)this.inventory);
    }

    private SpongeUser loadEnderInventory() {
        if (this.enderChest == null) {
            if (!this.isInitialized()) {
                this.initialize();
            }
            this.enderChest = new SpongeUserInventoryEnderchest(this);
            if (this.compound.contains("EnderItems", 9)) {
                ListNBT nbttaglist1 = this.compound.getList("EnderItems", 10);
                this.enderChest.read(nbttaglist1);
            }
        }
        return this;
    }

    public void writeToNbt(CompoundNBT compound) {
        compound.putString("Key", this.worldKey.getFormatted());
        this.loadInventory();
        this.loadEnderInventory();
        compound.put("Inventory", (INBT)this.inventory.writeToNBT(new ListNBT()));
        compound.put("EnderItems", (INBT)this.enderChest.write());
        compound.putInt("SelectedItemSlot", this.inventory.currentItem);
        compound.put("Pos", (INBT)Constants.NBT.newDoubleNBTList(this.x, this.y, this.z));
        compound.put("Rotation", (INBT)Constants.NBT.newFloatNBTList(this.yaw, this.pitch));
        compound.putBoolean("Invulnerable", this.invulnerable);
        CompoundNBT forgeCompound = compound.getCompound("ForgeData");
        CompoundNBT spongeCompound = forgeCompound.getCompound("SpongeData");
        spongeCompound.remove("Spawns");
        spongeCompound.remove("IsVanished");
        spongeCompound.remove("IsInvisible");
        spongeCompound.remove("VanishUnTargetable");
        spongeCompound.remove("VanishUnCollideable");
        ListNBT spawns = new ListNBT();
        for (Map.Entry<ResourceKey, RespawnLocation> entry : this.spawnLocations.entrySet()) {
            RespawnLocation respawn = entry.getValue();
            CompoundNBT spawnCompound = new CompoundNBT();
            spawnCompound.putString("Key", respawn.getWorldKey().getFormatted());
            spawnCompound.putDouble("SpawnX", respawn.getPosition().getX());
            spawnCompound.putDouble("SpawnY", respawn.getPosition().getY());
            spawnCompound.putDouble("SpawnZ", respawn.getPosition().getZ());
            spawnCompound.putBoolean("SpawnForced", false);
            spawns.add((Object)spawnCompound);
        }
        if (!spawns.isEmpty()) {
            spongeCompound.put("Spawns", (INBT)spawns);
        }
        if (this.isVanished) {
            spongeCompound.putBoolean("IsVanished", true);
            spongeCompound.putBoolean("VanishUnCollideable", this.isVanishCollide);
            spongeCompound.putBoolean("VanishUnTargetable", this.isVanishTarget);
        }
        if (this.isInvisible) {
            spongeCompound.putBoolean("IsInvisible", true);
        }
        forgeCompound.put("SpongeData", (INBT)spongeCompound);
        compound.put("ForgeData", (INBT)forgeCompound);
    }

    @Override
    public UUID getUniqueId() {
        return this.profile.getId();
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.Entity.Player.UUID, this.profile.getId()).set(Constants.Entity.Player.NAME, this.profile.getName()).set(Constants.Entity.Player.SPAWNS, this.spawnLocations);
    }

    @Override
    public boolean canEquip(EquipmentType type) {
        return true;
    }

    @Override
    public boolean canEquip(EquipmentType type, @Nullable ItemStack equipment) {
        return true;
    }

    @Override
    public Optional<ItemStack> getEquipped(EquipmentType type) {
        throw new MissingImplementationException("SpongeUser", "getEquipped");
    }

    @Override
    public boolean equip(EquipmentType type, @Nullable ItemStack equipment) {
        if (this.canEquip(type, equipment)) {
            this.loadInventory();
            this.setEquippedItem(type, equipment);
            return true;
        }
        return false;
    }

    @Override
    public UserInventory getInventory() {
        return this.loadInventory();
    }

    @Override
    public EquipmentInventory getEquipment() {
        return this.getInventory().getEquipment();
    }

    @Override
    public ItemStack getItemInHand(HandType handType) {
        if (handType == HandTypes.MAIN_HAND.get()) {
            this.getEquipped(EquipmentTypes.MAIN_HAND).orElseThrow(IllegalStateException::new);
        } else if (handType == HandTypes.OFF_HAND.get()) {
            this.getEquipped(EquipmentTypes.OFF_HAND).orElseThrow(IllegalStateException::new);
        }
        throw new IllegalArgumentException("Invalid hand " + handType);
    }

    @Override
    public ItemStack getHead() {
        return this.getEquipped(EquipmentTypes.HEAD).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void setHead(ItemStack helmet) {
        this.equip(EquipmentTypes.HEAD, helmet);
    }

    @Override
    public ItemStack getChest() {
        return this.getEquipped(EquipmentTypes.CHEST).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void setChest(ItemStack chestplate) {
        this.equip(EquipmentTypes.CHEST, chestplate);
    }

    @Override
    public ItemStack getLegs() {
        return this.getEquipped(EquipmentTypes.LEGS).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void setLegs(ItemStack leggings) {
        this.equip(EquipmentTypes.LEGS, leggings);
    }

    @Override
    public ItemStack getFeet() {
        return this.getEquipped(EquipmentTypes.FEET).orElseThrow(IllegalStateException::new);
    }

    @Override
    public void setFeet(ItemStack boots) {
        this.equip(EquipmentTypes.FEET, boots);
    }

    @Override
    public void setItemInHand(HandType handType, @Nullable ItemStack itemInHand) {
        if (handType == HandTypes.MAIN_HAND.get()) {
            this.setEquippedItem(EquipmentTypes.MAIN_HAND, itemInHand);
        } else if (handType == HandTypes.OFF_HAND.get()) {
            this.setEquippedItem(EquipmentTypes.OFF_HAND, itemInHand);
        } else {
            throw new IllegalArgumentException("Invalid hand " + handType);
        }
    }

    @Override
    public Map<ResourceKey, RespawnLocation> bridge$getBedlocations() {
        Optional<ServerPlayer> player = this.getPlayer();
        return player.map(value -> ((BedLocationHolderBridge)((Object)value)).bridge$getBedlocations()).orElse(this.spawnLocations);
    }

    @Override
    public boolean bridge$setBedLocations(Map<ResourceKey, RespawnLocation> value) {
        Optional<ServerPlayer> player = this.getPlayer();
        if (player.isPresent()) {
            return ((BedLocationHolderBridge)((Object)player.get())).bridge$setBedLocations(value);
        }
        this.spawnLocations.clear();
        this.spawnLocations.putAll(value);
        this.markDirty();
        return true;
    }

    @Override
    public ImmutableMap<ResourceKey, RespawnLocation> bridge$removeAllBeds() {
        Optional<ServerPlayer> player = this.getPlayer();
        if (player.isPresent()) {
            return ((BedLocationHolderBridge)((Object)player.get())).bridge$removeAllBeds();
        }
        ImmutableMap locations = ImmutableMap.copyOf(this.spawnLocations);
        this.spawnLocations.clear();
        this.markDirty();
        return locations;
    }

    public void markDirty() {
        if (this.isConstructing) {
            return;
        }
        if (!this.isInitialized()) {
            SpongeCommon.getLogger().warn("Unable to mark user data for [{}] as dirty, data is not initialized! Any changes may be lost.", (Object)this.profile.getId());
        } else {
            dirtyUsers.add(this);
        }
    }

    public void save() {
        CompoundNBT compound;
        Preconditions.checkState((boolean)this.isInitialized(), (String)"User {} is not initialized", (Object)this.profile.getId());
        SaveHandlerAccessor saveHandler = (SaveHandlerAccessor)((SpongeWorldManager)Sponge.getServer().getWorldManager()).getDefaultWorld();
        File dataFile = new File(saveHandler.accessor$getPlayersDirectory(), this.getUniqueId() + ".dat");
        try {
            compound = CompressedStreamTools.readCompressed((InputStream)new FileInputStream(dataFile));
        }
        catch (IOException ignored) {
            compound = new CompoundNBT();
        }
        this.writeToNbt(compound);
        try (FileOutputStream out = new FileOutputStream(dataFile);){
            CompressedStreamTools.writeCompressed((CompoundNBT)compound, (OutputStream)out);
            dirtyUsers.remove(this);
            this.invalidate();
        }
        catch (IOException e) {
            SpongeCommon.getLogger().warn("Failed to save user file [{}]!", (Object)dataFile, (Object)e);
        }
    }

    private void setEquippedItem(Supplier<? extends EquipmentType> type, @Nullable ItemStack item) {
        this.setEquippedItem(type.get(), item);
    }

    private void setEquippedItem(EquipmentType type, @Nullable ItemStack item) {
        throw new MissingImplementationException("SpongeUser", "setEquippedItem");
    }

    private net.minecraft.item.ItemStack getItemStackFromSlot(EquipmentSlotType slotIn) {
        this.loadInventory();
        if (slotIn == EquipmentSlotType.MAINHAND) {
            return this.inventory.getCurrentItem();
        }
        if (slotIn == EquipmentSlotType.OFFHAND) {
            return (net.minecraft.item.ItemStack)this.inventory.offHandInventory.get(0);
        }
        return slotIn.getSlotType() == EquipmentSlotType.Group.ARMOR ? (net.minecraft.item.ItemStack)this.inventory.armorInventory.get(slotIn.getIndex()) : net.minecraft.item.ItemStack.EMPTY;
    }

    private void setItemStackToSlot(EquipmentSlotType slotIn, net.minecraft.item.ItemStack stack) {
        this.loadInventory();
        if (slotIn == EquipmentSlotType.MAINHAND) {
            this.inventory.mainInventory.set(this.inventory.currentItem, (Object)stack);
        } else if (slotIn == EquipmentSlotType.OFFHAND) {
            this.inventory.offHandInventory.set(0, (Object)stack);
        } else if (slotIn.getSlotType() == EquipmentSlotType.Group.ARMOR) {
            this.inventory.armorInventory.set(slotIn.getIndex(), (Object)stack);
        }
    }

    @Override
    public org.spongepowered.api.profile.GameProfile getProfile() {
        return SpongeGameProfile.of(this.profile);
    }

    @Override
    public boolean isOnline() {
        return this.getPlayer().isPresent();
    }

    @Override
    public Optional<ServerPlayer> getPlayer() {
        return Optional.ofNullable((ServerPlayer)SpongeCommon.getServer().getPlayerList().getPlayerByUUID(this.profile.getId()));
    }

    @Override
    public Vector3d getPosition() {
        return this.getPlayer().map(Entity::getPosition).orElseGet(() -> new Vector3d(this.x, this.y, this.z));
    }

    @Override
    public ResourceKey getWorldKey() {
        Optional<ServerPlayer> player = this.getPlayer();
        return player.map(serverPlayer -> serverPlayer.getWorld().getKey()).orElseGet(() -> this.worldKey);
    }

    @Override
    public boolean setLocation(ResourceKey key, Vector3d position) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)position);
        Optional<ServerPlayer> player = this.getPlayer();
        if (player.isPresent()) {
            Optional<ServerWorld> world = Sponge.getServer().getWorldManager().getWorld(key);
            return world.filter(serverWorld -> ((ServerPlayer)player.get()).setLocation(ServerLocation.of(serverWorld, position))).isPresent();
        }
        this.worldKey = key;
        this.x = position.getX();
        this.y = position.getY();
        this.z = position.getZ();
        this.markDirty();
        return true;
    }

    @Override
    public Vector3d getRotation() {
        return this.getPlayer().map(Entity::getRotation).orElseGet(() -> new Vector3d(this.pitch, this.yaw, 0.0f));
    }

    @Override
    public void setRotation(Vector3d rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation was null!");
        Optional<ServerPlayer> playerOpt = this.getPlayer();
        if (playerOpt.isPresent()) {
            playerOpt.get().setRotation(rotation);
            return;
        }
        this.markDirty();
        this.pitch = (float)rotation.getX() % 360.0f;
        this.yaw = (float)rotation.getY() % 360.0f;
    }

    @Override
    public String getIdentifier() {
        return this.profile.getId().toString();
    }

    @Override
    public Inventory getEnderChestInventory() {
        Optional<ServerPlayer> playerOpt = this.getPlayer();
        if (playerOpt.isPresent()) {
            return playerOpt.get().getEnderChestInventory();
        }
        this.loadEnderInventory();
        return (Inventory)this.enderChest;
    }

    @Override
    public void bridge$setSubject(SubjectReference subj) {
        this.subjectReference = subj;
    }

    @Override
    public Optional<SubjectReference> bridge$resolveReferenceOptional() {
        if (this.subjectReference == null) {
            SubjectHelper.applySubject(this);
        }
        return Optional.ofNullable(this.subjectReference);
    }

    @Override
    public Optional<Subject> bridge$resolveOptional() {
        return this.bridge$resolveReferenceOptional().map(SubjectReference::resolve).map(CompletableFuture::join);
    }

    @Override
    public Subject bridge$resolve() {
        return this.bridge$resolveOptional().orElseThrow(() -> new IllegalStateException("No subject reference present for user " + this));
    }

    @Override
    public String bridge$getSubjectCollectionIdentifier() {
        return "user";
    }

    @Override
    public Tristate bridge$permDefault(String permission) {
        return Tristate.FALSE;
    }

    @Override
    public void bridge$setInvulnerable(boolean value) {
        Optional<ServerPlayer> playerOpt = this.getPlayer();
        if (playerOpt.isPresent()) {
            ((InvulnerableTrackedBridge)((Object)playerOpt.get())).bridge$setInvulnerable(value);
            return;
        }
        this.invulnerable = value;
        this.markDirty();
    }

    @Override
    public boolean bridge$getIsInvulnerable() {
        return this.invulnerable;
    }

    @Override
    public void bridge$setVanished(boolean vanished) {
        Optional<ServerPlayer> playerOpt = this.getPlayer();
        if (playerOpt.isPresent()) {
            ((VanishableBridge)((Object)playerOpt.get())).bridge$setVanished(vanished);
            return;
        }
        this.isVanished = vanished;
        this.markDirty();
    }

    @Override
    public boolean bridge$isVanished() {
        return this.getPlayer().map(player -> ((VanishableBridge)((Object)player)).bridge$isVanished()).orElseGet(() -> this.isVanished);
    }

    @Override
    public boolean bridge$isInvisible() {
        return this.getPlayer().map(player -> ((VanishableBridge)((Object)player)).bridge$isInvisible()).orElseGet(() -> this.isInvisible);
    }

    @Override
    public void bridge$setInvisible(boolean invisible) {
        Optional<ServerPlayer> player = this.getPlayer();
        if (player.isPresent()) {
            ((VanishableBridge)((Object)player.get())).bridge$setInvisible(invisible);
            return;
        }
        this.isInvisible = invisible;
    }

    @Override
    public boolean bridge$isUncollideable() {
        return this.getPlayer().map(player -> ((VanishableBridge)((Object)player)).bridge$isUncollideable()).orElseGet(() -> this.isVanishCollide);
    }

    @Override
    public void bridge$setUncollideable(boolean uncollideable) {
        Optional<ServerPlayer> player = this.getPlayer();
        if (player.isPresent()) {
            ((VanishableBridge)((Object)player.get())).bridge$setUncollideable(uncollideable);
            return;
        }
        this.isVanishCollide = uncollideable;
    }

    @Override
    public boolean bridge$isUntargetable() {
        return this.getPlayer().map(player -> ((VanishableBridge)((Object)player)).bridge$isUntargetable()).orElseGet(() -> this.isVanishTarget);
    }

    @Override
    public void bridge$setUntargetable(boolean untargetable) {
        Optional<ServerPlayer> player = this.getPlayer();
        if (player.isPresent()) {
            ((VanishableBridge)((Object)player.get())).bridge$setUntargetable(untargetable);
            return;
        }
        this.isVanishTarget = untargetable;
    }

    @Override
    public CompoundNBT data$getCompound() {
        return this.compound;
    }

    @Override
    public void data$setCompound(CompoundNBT nbt) {
        this.compound = nbt;
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.PLAYER;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpongeUser other = (SpongeUser)obj;
        return this.profile.getId().equals(other.profile.getId());
    }

    public int hashCode() {
        return this.profile.getId().hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isOnline", this.isOnline()).add("profile", (Object)this.getProfile()).toString();
    }

    @Override
    public GameProfile bridge$getGameProfile() {
        return this.profile;
    }
}

