/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.projectile.source.BlockProjectileSource;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.util.VecHelper;

public class ProjectileSourceSerializer {
    public static INBT toNbt(ProjectileSource projectileSource) {
        if (projectileSource instanceof org.spongepowered.api.entity.Entity) {
            return StringNBT.valueOf((String)((org.spongepowered.api.entity.Entity)((Object)projectileSource)).getUniqueId().toString());
        }
        if (projectileSource instanceof BlockProjectileSource) {
            return LongNBT.valueOf((long)VecHelper.toBlockPos(((BlockProjectileSource)projectileSource).getLocation()).toLong());
        }
        return null;
    }

    public static ProjectileSource fromNbt(World worldObj, INBT tag) {
        TileEntity tileEntity;
        BlockPos pos;
        org.spongepowered.api.entity.Entity entity;
        if (tag instanceof StringNBT && (entity = (org.spongepowered.api.entity.Entity)((org.spongepowered.api.world.World)worldObj).getEntity(UUID.fromString(tag.getString())).orElse(null)) instanceof ProjectileSource) {
            return (ProjectileSource)((Object)entity);
        }
        if (tag instanceof LongNBT && worldObj.isBlockLoaded(pos = BlockPos.fromLong((long)((LongNBT)tag).getLong())) && (tileEntity = worldObj.getTileEntity(pos)) instanceof ProjectileSource) {
            return (ProjectileSource)tileEntity;
        }
        return UnknownProjectileSource.UNKNOWN;
    }

    public static void writeSourceToNbt(CompoundNBT compound, @Nullable ProjectileSource projectileSource, Entity potentialEntity) {
        INBT projectileNbt;
        if (projectileSource == null && potentialEntity instanceof ProjectileSource) {
            projectileSource = (ProjectileSource)potentialEntity;
        }
        if ((projectileNbt = ProjectileSourceSerializer.toNbt(projectileSource)) != null) {
            compound.put("projectileSource", projectileNbt);
        }
    }

    public static void writeSourceToNbt(CompoundNBT compound, ProjectileSource projectileSource, UUID entityUid) {
        Object projectileNbt = projectileSource == null && entityUid != null ? StringNBT.valueOf((String)entityUid.toString()) : ProjectileSourceSerializer.toNbt(projectileSource);
        if (projectileNbt != null) {
            compound.put("projectileSource", projectileNbt);
        }
    }

    public static void readSourceFromNbt(CompoundNBT compound, Projectile projectile) {
        if (compound.contains("projectileSource")) {
            projectile.offer(Keys.SHOOTER, ProjectileSourceSerializer.fromNbt((World)projectile.getWorld(), compound.get("projectileSource")));
        }
    }
}

