/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import java.lang.reflect.Type;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Event;

public final class EventType<T extends Event> {
    private final Class<T> eventType;
    private final @Nullable Type genericType;
    private int hashCode;

    EventType(Class<T> eventType, @Nullable Type genericType) {
        this.genericType = genericType;
        this.eventType = eventType;
    }

    public EventType(Class<T> eventType) {
        this(eventType, null);
    }

    public Class<T> getType() {
        return this.eventType;
    }

    public @Nullable Type getGenericType() {
        return this.genericType;
    }

    public String toString() {
        String value = this.eventType.getName();
        if (this.genericType != null) {
            value = value + "<" + this.genericType.toString() + ">";
        }
        return value;
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof EventType)) {
            return false;
        }
        EventType that = (EventType)o;
        return that.eventType.equals(this.eventType) && Objects.equals(that.genericType, this.genericType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.eventType, this.genericType);
        }
        return this.hashCode;
    }
}

