/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.Preconditions;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.common.event.SpongeEventContextKey;
import org.spongepowered.common.util.TypeTokenUtil;

public final class SpongeEventContextKeyBuilder<T>
implements EventContextKey.Builder<T> {
    @Nullable
    Type typeClass;
    @Nullable
    ResourceKey key;

    @Override
    public <N> SpongeEventContextKeyBuilder<N> type(TypeToken<N> aClass) {
        Preconditions.checkArgument((aClass != null ? 1 : 0) != 0, (Object)"Class cannot be null!");
        this.typeClass = aClass.getType();
        return this;
    }

    @Override
    public <N> SpongeEventContextKeyBuilder<N> type(Class<N> aClass) {
        Preconditions.checkArgument((aClass != null ? 1 : 0) != 0, (Object)"Class cannot be null!");
        this.typeClass = TypeTokenUtil.requireCompleteGenerics(aClass);
        return this;
    }

    @Override
    public EventContextKey.Builder<T> key(ResourceKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"CatalogKey cannot be null!");
        this.key = key;
        return this;
    }

    @Override
    public EventContextKey<T> build() {
        Preconditions.checkState((this.typeClass != null ? 1 : 0) != 0, (Object)"Allowed type cannot be null!");
        Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"ID cannot be null!");
        Preconditions.checkState((!this.key.toString().isEmpty() ? 1 : 0) != 0, (Object)"ID cannot be empty!");
        SpongeEventContextKey key = new SpongeEventContextKey(this);
        return key;
    }

    @Override
    public SpongeEventContextKeyBuilder<T> reset() {
        this.typeClass = null;
        this.key = null;
        return this;
    }
}

