/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.common.accessor.util.DamageSourceAccessor;

public class SpongeEntityDamageSourceBuilder
extends AbstractDamageSourceBuilder<EntityDamageSource, EntityDamageSource.Builder>
implements EntityDamageSource.Builder {
    protected WeakReference<org.spongepowered.api.entity.Entity> reference = null;

    @Override
    public SpongeEntityDamageSourceBuilder entity(org.spongepowered.api.entity.Entity entity) {
        this.reference = new WeakReference<org.spongepowered.api.entity.Entity>(entity);
        return this;
    }

    @Override
    public EntityDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0, (Object)"Damage type cannot be null!");
        Preconditions.checkState((this.reference.get() != null ? 1 : 0) != 0);
        net.minecraft.util.EntityDamageSource damageSource = new net.minecraft.util.EntityDamageSource(this.damageType.getKey().getValue(), (Entity)this.reference.get());
        DamageSourceAccessor accessor = (DamageSourceAccessor)damageSource;
        if (this.creative) {
            accessor.accessor$setDamageAllowedInCreativeMode();
        }
        if (this.scales) {
            damageSource.setDifficultyScaled();
        }
        if (this.magical) {
            damageSource.setMagicDamage();
        }
        if (this.bypasses) {
            accessor.accessor$setDamageBypassesArmor();
        }
        if (this.absolute) {
            accessor.accessor$setDamageIsAbsolute();
        }
        if (this.explosion) {
            damageSource.setExplosion();
        }
        if (this.exhaustion != null) {
            accessor.accessor$setHungerDamage(this.exhaustion.floatValue());
        }
        return (EntityDamageSource)damageSource;
    }

    @Override
    public EntityDamageSource.Builder from(EntityDamageSource value) {
        super.from(value);
        this.reference = new WeakReference<org.spongepowered.api.entity.Entity>(value.getSource());
        return this;
    }

    @Override
    public SpongeEntityDamageSourceBuilder reset() {
        super.reset();
        this.reference = null;
        return this;
    }
}

