/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.common.event.tracking.PhaseTracker;

public class CauseStackFrameImpl
implements CauseStackManager.StackFrame {
    private final Map<EventContextKey<?>, Object> stored_ctx_values = new HashMap();
    private final PhaseTracker createdTracker;
    int old_min_depth;
    int lastCauseSize;
    private final Map<EventContextKey<?>, Object> storedContext = new HashMap();
    @Nullable
    Exception stack_debug = null;

    CauseStackFrameImpl(PhaseTracker phaseTracker) {
        this.createdTracker = phaseTracker;
    }

    public void clear() {
        this.stored_ctx_values.clear();
        this.storedContext.clear();
        this.lastCauseSize = -1;
        this.old_min_depth = -1;
        this.stack_debug = null;
    }

    public CauseStackFrameImpl set(int old_depth, int size) {
        this.old_min_depth = old_depth;
        this.lastCauseSize = size;
        return this;
    }

    public boolean isStored(EventContextKey<?> key) {
        return this.stored_ctx_values != null && this.stored_ctx_values.containsKey(key);
    }

    public Set<Map.Entry<EventContextKey<?>, Object>> getStoredValues() {
        return this.stored_ctx_values.entrySet();
    }

    public boolean hasStoredValues() {
        return !this.stored_ctx_values.isEmpty();
    }

    public void store(EventContextKey<?> key, Object existing) {
        this.stored_ctx_values.put(key, existing);
    }

    void storeOriginalContext(EventContextKey<?> key, @Nullable Object object) {
        if (!this.storedContext.containsKey(key)) {
            this.storedContext.put(key, object);
        }
    }

    Map<EventContextKey<?>, Object> getOriginalContextDelta() {
        return this.storedContext;
    }

    @Override
    public Cause getCurrentCause() {
        return PhaseTracker.getCauseStackManager().getCurrentCause();
    }

    @Override
    public EventContext getCurrentContext() {
        return PhaseTracker.getCauseStackManager().getCurrentContext();
    }

    @Override
    public CauseStackManager.StackFrame pushCause(Object obj) {
        PhaseTracker.getCauseStackManager().pushCause(obj);
        return this;
    }

    @Override
    public Object popCause() {
        return PhaseTracker.getCauseStackManager().popCause();
    }

    @Override
    public <T> CauseStackManager.StackFrame addContext(EventContextKey<T> key, T value) {
        PhaseTracker.getCauseStackManager().addContext(key, value);
        return this;
    }

    @Override
    public <T> Optional<T> removeContext(EventContextKey<T> key) {
        return PhaseTracker.getCauseStackManager().removeContext(key);
    }

    @Override
    public void close() {
        PhaseTracker.getCauseStackManager().popCauseFrame(this);
    }
}

