/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.BlockEventBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.util.PrettyPrinter;

public final class AddTileEntity
extends BlockEventBasedTransaction {
    final TileEntity added;
    final SpongeBlockSnapshot oldSnapshot;
    final SpongeBlockSnapshot addedSnapshot;

    AddTileEntity(TileEntity added, SpongeBlockSnapshot attachedSnapshot, SpongeBlockSnapshot existing) {
        super(existing.getBlockPos(), (BlockState)existing.getState(), ((ServerWorld)added.getWorld()).getKey());
        this.added = added;
        this.addedSnapshot = attachedSnapshot;
        this.oldSnapshot = existing;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("AddTileEntity").addWrapped(120, " %s : %s", this.affectedPosition, ((TileEntityBridge)this.added).bridge$getPrettyPrinterString());
    }

    @Override
    public void restore() {
        this.oldSnapshot.restore(true, BlockChangeFlags.NONE);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return this.addedSnapshot;
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.addedSnapshot;
    }
}

