/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.util.PrettyPrinter;

public abstract class GameTransaction<E extends Event & Cancellable> {
    private final TransactionType<? extends E> transactionType;
    protected final ResourceKey worldKey;
    boolean cancelled = false;
    @Nullable LinkedList<ResultingTransactionBySideEffect> sideEffects;
    @Nullable GameTransaction<@NonNull ?> previous;
    @Nullable GameTransaction<@NonNull ?> next;

    GameTransaction(TransactionType<? extends E> transactionType, ResourceKey worldKey) {
        this.transactionType = transactionType;
        this.worldKey = worldKey;
    }

    public String toString() {
        return new StringJoiner(", ", GameTransaction.class.getSimpleName() + "[", "]").toString();
    }

    public TransactionType<? extends E> getTransactionType() {
        return this.transactionType;
    }

    Deque<ResultingTransactionBySideEffect> getEffects() {
        if (this.sideEffects == null) {
            this.sideEffects = new LinkedList();
        }
        return this.sideEffects;
    }

    public final boolean hasChildTransactions() {
        return this.sideEffects != null && this.sideEffects.stream().anyMatch(effect -> effect.head != null);
    }

    public final boolean hasAnyPrimaryChildrenTransactions() {
        if (this.sideEffects == null) {
            return false;
        }
        for (ResultingTransactionBySideEffect sideEffect : this.sideEffects) {
            @Nullable GameTransaction<@NonNull ?> transaction = sideEffect.head;
            while (transaction != null) {
                if (transaction.transactionType.isPrimary() || transaction.hasChildTransactions()) {
                    return true;
                }
                transaction = transaction.next;
            }
        }
        return false;
    }

    public abstract Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> var1);

    public abstract void addToPrinter(PrettyPrinter var1);

    public boolean acceptTileRemoval(@Nullable TileEntity tileentity) {
        return false;
    }

    public boolean acceptTileAddition(TileEntity tileEntity) {
        return false;
    }

    public boolean acceptTileReplacement(@Nullable TileEntity existing, TileEntity proposed) {
        return false;
    }

    public boolean acceptEntityDrops(Entity entity) {
        return false;
    }

    public boolean isUnbatchable() {
        return false;
    }

    public abstract Optional<E> generateEvent(PhaseContext<@NonNull ?> var1, @Nullable GameTransaction<@NonNull ?> var2, ImmutableList<GameTransaction<E>> var3, Cause var4, ImmutableMultimap.Builder<TransactionType, ? extends Event> var5);

    public abstract void restore();

    public void markCancelled() {
        this.cancelled = true;
        if (this.sideEffects != null) {
            for (ResultingTransactionBySideEffect sideEffect : this.sideEffects) {
                if (sideEffect.head == null) continue;
                @Nullable GameTransaction<@NonNull ?> node = sideEffect.head;
                while (node != null) {
                    node.markCancelled();
                    node = node.next;
                }
            }
        }
    }

    public abstract boolean markCancelledTransactions(E var1, ImmutableList<? extends GameTransaction<E>> var2);

    public void postProcessEvent(PhaseContext<@NonNull ?> context, E event) {
    }
}

