/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.BlockEventBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.math.vector.Vector3i;

public final class RemoveTileEntity
extends BlockEventBasedTransaction {
    final TileEntity removed;
    final SpongeBlockSnapshot tileSnapshot;

    RemoveTileEntity(TileEntity removed, SpongeBlockSnapshot attachedSnapshot) {
        super(attachedSnapshot.getBlockPos(), (BlockState)attachedSnapshot.getState(), attachedSnapshot.getWorld());
        this.removed = removed;
        this.tileSnapshot = attachedSnapshot;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("RemoveTileEntity").add(" %s : %s", this.affectedPosition, ((TileEntityBridge)this.removed).bridge$getPrettyPrinterString()).add(" %s : %s", this.affectedPosition, this.originalState);
    }

    @Override
    public void restore() {
        this.tileSnapshot.restore(true, BlockChangeFlags.NONE);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return SpongeBlockSnapshotBuilder.pooled().world((ServerWorld)this.removed.getWorld()).position(new Vector3i(this.affectedPosition.getX(), this.affectedPosition.getY(), this.affectedPosition.getZ())).blockState(this.originalState).build();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.tileSnapshot;
    }
}

