/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.server.ServerWorldAccessor;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.math.vector.Vector3d;

public final class SpawnEntityTransaction
extends GameTransaction<SpawnEntityEvent> {
    final Supplier<net.minecraft.world.server.ServerWorld> worldSupplier;
    final CompoundNBT entityTag;
    final Entity entityToSpawn;
    final Vector3d originalPosition;
    final Supplier<SpawnType> deducedSpawnType;

    SpawnEntityTransaction(Supplier<net.minecraft.world.server.ServerWorld> worldSupplier, Entity entityToSpawn, Supplier<SpawnType> deducedSpawnType) {
        super(TransactionTypes.SPAWN_ENTITY.get(), ((ServerWorld)worldSupplier.get()).getKey());
        this.worldSupplier = worldSupplier;
        this.entityToSpawn = entityToSpawn;
        this.entityTag = entityToSpawn.writeWithoutTypeId(new CompoundNBT());
        this.originalPosition = new Vector3d(entityToSpawn.getPosX(), entityToSpawn.getPosY(), entityToSpawn.getPosZ());
        this.deducedSpawnType = deducedSpawnType;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        if (parent instanceof ChangeBlock) {
            return Optional.of((phaseContext, stackFrame) -> {
                stackFrame.pushCause(((ChangeBlock)parent).original);
                stackFrame.addContext(EventContextKeys.BLOCK_TARGET, ((ChangeBlock)parent).original);
            });
        }
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    public Optional<SpawnEntityEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<SpawnEntityEvent>> gameTransactions, Cause currentCause, ImmutableMultimap.Builder<TransactionType, ? extends Event> transactionPostEventBuilder) {
        ImmutableList collect = (ImmutableList)gameTransactions.stream().map(transaction -> (SpawnEntityTransaction)transaction).map(spawnRequest -> new Tuple<Entity, DummySnapshot>(spawnRequest.entityToSpawn, new DummySnapshot(spawnRequest.originalPosition, spawnRequest.entityTag, spawnRequest.worldSupplier))).collect(ImmutableList.toImmutableList());
        return Optional.of(context.state.createSpawnEvent(context, parent, (ImmutableList<Tuple<Entity, DummySnapshot>>)collect, currentCause));
    }

    @Override
    public void restore() {
        net.minecraft.world.server.ServerWorld serverWorld = this.worldSupplier.get();
        if (((ServerWorldAccessor)serverWorld).accessor$isTickingEntities()) {
            ((ServerWorldAccessor)serverWorld).accessor$getEntitiesToAdd().remove(this.entityToSpawn);
            ((ServerWorldAccessor)serverWorld).accessor$removeFromChunk(this.entityToSpawn);
        } else {
            serverWorld.removeEntity(this.entityToSpawn);
        }
    }

    @Override
    public boolean markCancelledTransactions(SpawnEntityEvent event, ImmutableList<? extends GameTransaction<SpawnEntityEvent>> gameTransactions) {
        return false;
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, SpawnEntityEvent event) {
    }

    public static final class DummySnapshot {
        final Vector3d originalPosition;
        final CompoundNBT entityTag;
        final Supplier<net.minecraft.world.server.ServerWorld> worldSupplier;

        public DummySnapshot(Vector3d originalPosition, CompoundNBT entityTag, Supplier<net.minecraft.world.server.ServerWorld> worldSupplier) {
            this.originalPosition = originalPosition;
            this.entityTag = entityTag;
            this.worldSupplier = worldSupplier;
        }
    }
}

