/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.util.Supplier;
import org.spongepowered.common.accessor.world.WorldAccessor;
import org.spongepowered.common.accessor.world.server.ServerWorldAccessor;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class AddTileEntityToWorldWhileProcessingEffect
implements ProcessingSideEffect {
    public static AddTileEntityToWorldWhileProcessingEffect getInstance() {
        return Holder.INSTANCE;
    }

    AddTileEntityToWorldWhileProcessingEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        ServerWorld serverWorld = pipeline.getServerWorld();
        TileEntity tileEntity = oldState.tileEntity;
        if (tileEntity == null) {
            return EffectResult.NULL_RETURN;
        }
        if (((WorldAccessor)serverWorld).accessor$getProcessingLoadedTiles()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> Registry.BLOCK_ENTITY_TYPE.getKey((Object)tileEntity.getType());
            supplierArray[1] = () -> ((TileEntity)tileEntity).getPos();
            ServerWorldAccessor.accessor$LOGGER().error("Adding block entity while ticking: {} @ {}", supplierArray);
            boolean add = ((WorldAccessor)serverWorld).accessor$getAddedTileEntityList().add(tileEntity);
            if (add) {
                return new EffectResult(oldState.state, true);
            }
            return EffectResult.NULL_RETURN;
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final AddTileEntityToWorldWhileProcessingEffect INSTANCE = new AddTileEntityToWorldWhileProcessingEffect();

        private Holder() {
        }
    }
}

