/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class SpawnDestructBlocksEffect
implements ProcessingSideEffect {
    public static SpawnDestructBlocksEffect getInstance() {
        return Holder.INSTANCE;
    }

    SpawnDestructBlocksEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        ServerWorld world = pipeline.getServerWorld();
        BlockPos pos = oldState.pos;
        List<ItemStack> drops = oldState.drops;
        drops.forEach(drop -> Block.spawnAsEntity((World)world, (BlockPos)pos, (ItemStack)drop));
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final SpawnDestructBlocksEffect INSTANCE = new SpawnDestructBlocksEffect();

        private Holder() {
        }
    }
}

