/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.Heightmap;
import org.spongepowered.common.accessor.world.chunk.ChunkAccessor;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class UpdateHeightMapEffect
implements ProcessingSideEffect {
    UpdateHeightMapEffect() {
    }

    public static UpdateHeightMapEffect getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        Map<Heightmap.Type, Heightmap> heightMap = ((ChunkAccessor)pipeline.getAffectedChunk()).accessor$getHeightMap();
        if (heightMap == null) {
            throw new IllegalStateException("Heightmap dereferenced!");
        }
        int x = oldState.pos.getX() & 0xF;
        int y = oldState.pos.getY();
        int z = oldState.pos.getZ() & 0xF;
        heightMap.get(Heightmap.Type.MOTION_BLOCKING).update(x, y, z, newState);
        heightMap.get(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).update(x, y, z, newState);
        heightMap.get(Heightmap.Type.OCEAN_FLOOR).update(x, y, z, newState);
        heightMap.get(Heightmap.Type.WORLD_SURFACE).update(x, y, z, newState);
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final UpdateHeightMapEffect INSTANCE = new UpdateHeightMapEffect();

        private Holder() {
        }
    }
}

