/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.world.BlockChange;

final class CommandState
extends GeneralState<CommandPhaseContext> {
    private final BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> COMMAND_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> ctx.getSource(Object.class).ifPresent(frame::pushCause));

    CommandState() {
    }

    @Override
    public CommandPhaseContext createNewContext(PhaseTracker tracker) {
        return (CommandPhaseContext)((CommandPhaseContext)new CommandPhaseContext(this, tracker).addCaptures()).addEntityDropCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> getFrameModifier() {
        return this.COMMAND_MODIFIER;
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> transaction, CommandPhaseContext context) {
        PhaseTracker.getCauseStackManager().getCurrentCause().first(User.class).ifPresent(user -> TrackingUtil.associateTrackerToTarget(blockChange, transaction, user));
    }

    @Override
    public void associateNeighborStateNotifier(CommandPhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        context.getSource(Player.class).ifPresent(player -> ((ChunkBridge)minecraftWorld.getChunkAt(notifyPos)).bridge$addTrackedBlockPosition(block, notifyPos, ((ServerPlayer)player).getUser(), PlayerTracker.Type.NOTIFIER));
    }

    @Override
    public void unwind(CommandPhaseContext phaseContext) {
        Optional<PlayerEntity> playerSource = phaseContext.getSource(PlayerEntity.class);
        CauseStackManager csm = PhaseTracker.getCauseStackManager();
        if (playerSource.isPresent()) {
            ((TrackedInventoryBridge)playerSource.get().inventory).bridge$setCaptureInventory(false);
            List<SlotTransaction> list = ((TrackedInventoryBridge)playerSource.get().inventory).bridge$getCapturedSlotTransactions();
            if (!list.isEmpty()) {
                ChangeInventoryEvent event = SpongeEventFactory.createChangeInventoryEvent(csm.getCurrentCause(), (Inventory)playerSource.get().inventory, list);
                SpongeCommon.postEvent(event);
                PacketPhaseUtil.handleSlotRestore(playerSource.get(), null, list, event.isCancelled());
                list.clear();
            }
        }
        TrackingUtil.processBlockCaptures(phaseContext);
    }
}

