/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.util.PrettyPrinter;

public class PacketContext<P extends PacketContext<P>>
extends PhaseContext<P> {
    protected ServerPlayerEntity packetPlayer;
    @Nullable
    IPacket<?> packet;
    private ItemStackSnapshot cursor = ItemStackSnapshot.empty();
    private ItemStack itemUsed = ItemStack.empty();
    private ItemStackSnapshot itemUsedSnapshot = ItemStackSnapshot.empty();
    @Nullable
    private HandType handUsed;
    private boolean ignoreCreative;
    private boolean interactItemChanged;

    protected PacketContext(PacketState<? extends P> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    public P packet(IPacket<?> packet) {
        this.packet = packet;
        return (P)this;
    }

    public P packetPlayer(ServerPlayerEntity playerMP) {
        this.packetPlayer = playerMP;
        return (P)this;
    }

    public P cursor(ItemStackSnapshot snapshot) {
        this.cursor = snapshot;
        return (P)this;
    }

    public P ignoreCreative(boolean creative) {
        this.ignoreCreative = creative;
        return (P)this;
    }

    public ServerPlayerEntity getPacketPlayer() {
        return this.packetPlayer;
    }

    public ServerPlayer getSpongePlayer() {
        return (ServerPlayer)this.packetPlayer;
    }

    public <K extends IPacket<?>> K getPacket() {
        return (K)this.packet;
    }

    public ItemStackSnapshot getCursor() {
        return this.cursor;
    }

    public boolean getIgnoringCreative() {
        return this.ignoreCreative;
    }

    public P itemUsed(ItemStack stack) {
        this.itemUsed = stack;
        this.itemUsedSnapshot = this.itemUsed.createSnapshot();
        return (P)this;
    }

    public ItemStack getItemUsed() {
        return this.itemUsed;
    }

    public ItemStackSnapshot getItemUsedSnapshot() {
        return this.itemUsedSnapshot;
    }

    public P interactItemChanged(boolean changed) {
        this.interactItemChanged = changed;
        return (P)this;
    }

    public boolean getInteractItemChanged() {
        return this.interactItemChanged;
    }

    public P handUsed(HandType hand) {
        this.handUsed = hand;
        return (P)this;
    }

    public HandType getHandUsed() {
        return this.handUsed;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s2 = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s2 + "- %s: %s", "PacketPlayer", this.packetPlayer).add(s2 + "- %s: %s", "Packet", this.packet).add(s2 + "- %s: %s", "IgnoreCreative", this.ignoreCreative).add(s2 + "- %s: %s", "ItemStackUsed", this.itemUsed);
    }

    @Override
    protected void reset() {
        super.reset();
        this.packetPlayer = null;
        this.packet = null;
        this.cursor = ItemStackSnapshot.empty();
        this.itemUsed = ItemStack.empty();
        this.itemUsedSnapshot = ItemStackSnapshot.empty();
        this.handUsed = null;
        this.ignoreCreative = false;
        this.interactItemChanged = false;
    }
}

