/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.client.CConfirmTransactionPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.network.play.client.CKeepAlivePacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CResourcePackStatusPacket;
import net.minecraft.network.play.client.CSpectatePacket;
import net.minecraft.network.play.client.CTabCompletePacket;
import net.minecraft.network.play.client.CUpdateSignPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryAddSlotState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryStartState;
import org.spongepowered.common.event.tracking.phase.packet.drag.MiddleDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.PrimaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.SecondaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.CloseWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.CreativeInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DoubleClickInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemOutsideWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemWithHotkeyState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.EnchantItemPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.MiddleInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.OpenInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PlaceRecipePacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PrimaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PrimaryInventoryShiftClick;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SecondaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SecondaryInventoryShiftClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwapHandItemsState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwitchHotbarNumberPressState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwitchHotbarScrollState;
import org.spongepowered.common.event.tracking.phase.packet.player.AnimationPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.AttackEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.IgnoredPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractAtEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InvalidPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.MovementPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.PlaceBlockPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.ResourcePackState;
import org.spongepowered.common.event.tracking.phase.packet.player.StopSleepingPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.UnknownPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.UpdateSignState;
import org.spongepowered.common.event.tracking.phase.packet.player.UseItemPacketState;
import org.spongepowered.common.util.Constants;

public final class PacketPhase {
    private final Map<Class<? extends IPacket<?>>, Function<IPacket<?>, IPhaseState<? extends PacketContext<?>>>> packetTranslationMap = new IdentityHashMap();
    private static final ImmutableMap<CEntityActionPacket.Action, IPhaseState<? extends PacketContext<?>>> PLAYER_ACTION_MAPPINGS = ImmutableMap.builder().put((Object)CEntityActionPacket.Action.PRESS_SHIFT_KEY, General.PRESS_SHIFT_KEY).put((Object)CEntityActionPacket.Action.RELEASE_SHIFT_KEY, General.RELEASE_SHIFT_KEY).put((Object)CEntityActionPacket.Action.STOP_SLEEPING, General.STOP_SLEEPING).put((Object)CEntityActionPacket.Action.START_SPRINTING, General.START_SPRINTING).put((Object)CEntityActionPacket.Action.STOP_SPRINTING, General.STOP_SPRINTING).put((Object)CEntityActionPacket.Action.START_RIDING_JUMP, General.START_RIDING_JUMP).put((Object)CEntityActionPacket.Action.STOP_RIDING_JUMP, General.STOP_RIDING_JUMP).put((Object)CEntityActionPacket.Action.OPEN_INVENTORY, (Object)Inventory.OPEN_INVENTORY).put((Object)CEntityActionPacket.Action.START_FALL_FLYING, General.START_FALL_FLYING).build();
    private static final ImmutableMap<CPlayerDiggingPacket.Action, IPhaseState<? extends PacketContext<?>>> INTERACTION_ACTION_MAPPINGS = ImmutableMap.builder().put((Object)CPlayerDiggingPacket.Action.DROP_ITEM, (Object)Inventory.DROP_ITEM_WITH_HOTKEY).put((Object)CPlayerDiggingPacket.Action.DROP_ALL_ITEMS, (Object)Inventory.DROP_ITEM_WITH_HOTKEY).put((Object)CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, General.INTERACTION).put((Object)CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, General.INTERACTION).put((Object)CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, General.INTERACTION).put((Object)CPlayerDiggingPacket.Action.RELEASE_USE_ITEM, General.INTERACTION).put((Object)CPlayerDiggingPacket.Action.SWAP_HELD_ITEMS, (Object)Inventory.SWAP_HAND_ITEMS).build();

    boolean isPacketInvalid(IPacket<?> packetIn, ServerPlayerEntity packetPlayer, IPhaseState<? extends PacketContext<?>> packetState) {
        return ((PacketState)packetState).isPacketIgnored(packetIn, packetPlayer);
    }

    IPhaseState<? extends PacketContext<?>> getStateForPacket(IPacket<?> packet) {
        Function<IPacket<?>, IPhaseState<PacketContext<?>>> packetStateFunction = this.packetTranslationMap.get(packet.getClass());
        if (packetStateFunction != null) {
            return packetStateFunction.apply(packet);
        }
        return General.UNKNOWN;
    }

    public PhaseContext<?> populateContext(IPacket<?> packet, ServerPlayerEntity entityPlayerMP, IPhaseState<?> state, PhaseContext<?> context) {
        Preconditions.checkNotNull(packet, (Object)"Packet cannot be null!");
        Preconditions.checkArgument((!context.isComplete() ? 1 : 0) != 0, (Object)"PhaseContext cannot be marked as completed!");
        ((PacketState)state).populateContext(entityPlayerMP, packet, (PacketContext)context);
        return context;
    }

    private static BasicInventoryPacketState fromWindowPacket(CClickWindowPacket windowPacket) {
        int mode = 512 << windowPacket.getClickType().ordinal();
        int packed = windowPacket.getUsedButton();
        int unpacked = mode == Constants.Networking.MODE_DRAG ? 64 << (packed >> 2 & 3) | 8 << (packed & 3) : 1 << (packed & 3);
        BasicInventoryPacketState inventory = PacketPhase.fromState(PacketPhase.clickType(windowPacket.getSlotId()) | mode | unpacked);
        if (inventory == Inventory.INVENTORY) {
            SpongeCommon.getLogger().warn(String.format("Unable to find InventoryPacketState handler for click window packet: %s", windowPacket));
        }
        return inventory;
    }

    private static int clickType(int slotId) {
        return slotId == -999 || slotId == -1 ? 131072 : 65536;
    }

    private static BasicInventoryPacketState fromState(int state) {
        for (BasicInventoryPacketState inventory : Inventory.VALUES) {
            if (!inventory.matches(state)) continue;
            return inventory;
        }
        return Inventory.INVENTORY;
    }

    public static PacketPhase getInstance() {
        return Holder.INSTANCE;
    }

    PacketPhase() {
        this.setupPacketToStateMapping();
    }

    private void setupPacketToStateMapping() {
        this.packetTranslationMap.put(CKeepAlivePacket.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CChatMessagePacket.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CUseEntityPacket.class, packet -> {
            CUseEntityPacket useEntityPacket = (CUseEntityPacket)packet;
            CUseEntityPacket.Action action = useEntityPacket.getAction();
            if (action == CUseEntityPacket.Action.INTERACT) {
                return General.INTERACT_ENTITY;
            }
            if (action == CUseEntityPacket.Action.ATTACK) {
                return General.ATTACK_ENTITY;
            }
            if (action == CUseEntityPacket.Action.INTERACT_AT) {
                return General.INTERACT_AT_ENTITY;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(CPlayerPacket.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPlayerPacket.PositionPacket.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPlayerPacket.RotationPacket.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPlayerPacket.PositionRotationPacket.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPlayerDiggingPacket.class, packet -> {
            CPlayerDiggingPacket playerDigging = (CPlayerDiggingPacket)packet;
            CPlayerDiggingPacket.Action action = playerDigging.getAction();
            IPhaseState state = (IPhaseState)INTERACTION_ACTION_MAPPINGS.get((Object)action);
            return state == null ? General.UNKNOWN : state;
        });
        this.packetTranslationMap.put(CPlayerTryUseItemOnBlockPacket.class, packet -> {
            CPlayerTryUseItemOnBlockPacket blockPlace = (CPlayerTryUseItemOnBlockPacket)packet;
            BlockPos blockPos = blockPlace.func_218794_c().getPos();
            Direction front = blockPlace.func_218794_c().getFace();
            MinecraftServer server = SpongeCommon.getServer();
            if (blockPos.getY() < server.getBuildLimit() - 1 || front != Direction.UP && blockPos.getY() < server.getBuildLimit()) {
                return General.PLACE_BLOCK;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(CPlayerTryUseItemPacket.class, packet -> General.USE_ITEM);
        this.packetTranslationMap.put(CHeldItemChangePacket.class, packet -> Inventory.SWITCH_HOTBAR_SCROLL);
        this.packetTranslationMap.put(CAnimateHandPacket.class, packet -> General.ANIMATION);
        this.packetTranslationMap.put(CEntityActionPacket.class, packet -> {
            CEntityActionPacket playerAction = (CEntityActionPacket)packet;
            CEntityActionPacket.Action action = playerAction.getAction();
            return (IPhaseState)PLAYER_ACTION_MAPPINGS.get((Object)action);
        });
        this.packetTranslationMap.put(CInputPacket.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CCloseWindowPacket.class, packet -> General.CLOSE_WINDOW);
        this.packetTranslationMap.put(CClickWindowPacket.class, packet -> PacketPhase.fromWindowPacket((CClickWindowPacket)packet));
        this.packetTranslationMap.put(CConfirmTransactionPacket.class, packet -> General.UNKNOWN);
        this.packetTranslationMap.put(CCreativeInventoryActionPacket.class, packet -> General.CREATIVE_INVENTORY);
        this.packetTranslationMap.put(CEnchantItemPacket.class, packet -> Inventory.ENCHANT_ITEM);
        this.packetTranslationMap.put(CUpdateSignPacket.class, packet -> General.UPDATE_SIGN);
        this.packetTranslationMap.put(CPlayerAbilitiesPacket.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CTabCompletePacket.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CClientStatusPacket.class, packet -> {
            CClientStatusPacket clientStatus = (CClientStatusPacket)packet;
            CClientStatusPacket.State status = clientStatus.getStatus();
            if (status == CClientStatusPacket.State.PERFORM_RESPAWN) {
                return General.REQUEST_RESPAWN;
            }
            return General.IGNORED;
        });
        this.packetTranslationMap.put(CCustomPayloadPacket.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CSpectatePacket.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CResourcePackStatusPacket.class, packet -> General.RESOURCE_PACK);
        this.packetTranslationMap.put(CPlaceRecipePacket.class, packet -> Inventory.PLACE_RECIPE);
    }

    private static final class Holder {
        static final PacketPhase INSTANCE = new PacketPhase();

        private Holder() {
        }
    }

    public static final class Inventory {
        static final BasicInventoryPacketState INVENTORY = new BasicInventoryPacketState();
        public static final BasicInventoryPacketState PRIMARY_INVENTORY_CLICK = new PrimaryInventoryClickState();
        public static final BasicInventoryPacketState SECONDARY_INVENTORY_CLICK = new SecondaryInventoryClickState();
        public static final BasicInventoryPacketState MIDDLE_INVENTORY_CLICK = new MiddleInventoryClickState();
        public static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW = new DropItemOutsideWindowState(Constants.Networking.MODE_CLICK | 1 | 2 | 0x20000);
        public static final BasicInventoryPacketState DROP_ITEM_WITH_HOTKEY = new DropItemWithHotkeyState();
        public static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW_NOOP = new DropItemOutsideWindowState(Constants.Networking.MODE_DROP | 1 | 2 | 0x20000);
        public static final BasicInventoryPacketState DROP_ITEMS = new BasicInventoryPacketState();
        static final BasicInventoryPacketState DROP_INVENTORY = new DropInventoryState();
        public static final BasicInventoryPacketState SWITCH_HOTBAR_NUMBER_PRESS = new SwitchHotbarNumberPressState();
        public static final BasicInventoryPacketState PRIMARY_INVENTORY_SHIFT_CLICK = new PrimaryInventoryShiftClick();
        public static final BasicInventoryPacketState SECONDARY_INVENTORY_SHIFT_CLICK = new SecondaryInventoryShiftClickState();
        static final BasicInventoryPacketState DOUBLE_CLICK_INVENTORY = new DoubleClickInventoryState();
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_START = new DragInventoryStartState("PRIMARY_DRAG_INVENTORY_START", 64);
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_START = new DragInventoryStartState("SECONDARY_DRAG_INVENTORY_START", 128);
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_START = new DragInventoryStartState("MIDDLE_DRAG_INVENTORY_START", 256);
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("PRIMARY_DRAG_INVENTORY_ADD_SLOT", 64);
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("SECONDARY_DRAG_INVENTORY_ADD_SLOT", 128);
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("MIDDLE_DRAG_INVENTORY_ADD_SLOT", 256);
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_STOP = new PrimaryDragInventoryStopState();
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_STOP = new SecondaryDragInventoryStopState();
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_STOP = new MiddleDragInventoryStopState();
        public static final BasicInventoryPacketState SWITCH_HOTBAR_SCROLL = new SwitchHotbarScrollState();
        public static final BasicInventoryPacketState OPEN_INVENTORY = new OpenInventoryState();
        static final BasicInventoryPacketState ENCHANT_ITEM = new EnchantItemPacketState();
        public static final BasicInventoryPacketState SWAP_HAND_ITEMS = new SwapHandItemsState();
        public static final BasicInventoryPacketState PLACE_RECIPE = new PlaceRecipePacketState();
        static final ImmutableList<BasicInventoryPacketState> VALUES = ImmutableList.builder().add((Object)INVENTORY).add((Object)PRIMARY_INVENTORY_CLICK).add((Object)SECONDARY_INVENTORY_CLICK).add((Object)MIDDLE_INVENTORY_CLICK).add((Object)DROP_ITEM_OUTSIDE_WINDOW).add((Object)DROP_ITEM_WITH_HOTKEY).add((Object)DROP_ITEM_OUTSIDE_WINDOW_NOOP).add((Object)DROP_ITEMS).add((Object)DROP_INVENTORY).add((Object)SWITCH_HOTBAR_NUMBER_PRESS).add((Object)PRIMARY_INVENTORY_SHIFT_CLICK).add((Object)SECONDARY_INVENTORY_SHIFT_CLICK).add((Object)DOUBLE_CLICK_INVENTORY).add((Object)PRIMARY_DRAG_INVENTORY_START).add((Object)SECONDARY_DRAG_INVENTORY_START).add((Object)MIDDLE_DRAG_INVENTORY_START).add((Object)PRIMARY_DRAG_INVENTORY_ADDSLOT).add((Object)SECONDARY_DRAG_INVENTORY_ADDSLOT).add((Object)MIDDLE_DRAG_INVENTORY_ADDSLOT).add((Object)PRIMARY_DRAG_INVENTORY_STOP).add((Object)SECONDARY_DRAG_INVENTORY_STOP).add((Object)MIDDLE_DRAG_INVENTORY_STOP).add((Object)SWITCH_HOTBAR_SCROLL).add((Object)OPEN_INVENTORY).add((Object)ENCHANT_ITEM).build();
    }

    public static final class General {
        public static final IPhaseState<BasicPacketContext> UNKNOWN = new UnknownPacketState();
        static final IPhaseState<BasicPacketContext> MOVEMENT = new MovementPacketState();
        static final IPhaseState<InteractionPacketContext> INTERACTION = new InteractionPacketState();
        static final IPhaseState<BasicPacketContext> IGNORED = new IgnoredPacketState();
        static final IPhaseState<BasicPacketContext> INTERACT_ENTITY = new InteractEntityPacketState();
        static final IPhaseState<BasicPacketContext> ATTACK_ENTITY = new AttackEntityPacketState();
        static final IPhaseState<BasicPacketContext> INTERACT_AT_ENTITY = new InteractAtEntityPacketState();
        static final IPhaseState<BasicPacketContext> CREATIVE_INVENTORY = new CreativeInventoryPacketState();
        static final IPhaseState<BasicPacketContext> PLACE_BLOCK = new PlaceBlockPacketState();
        static final IPhaseState<BasicPacketContext> REQUEST_RESPAWN = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> USE_ITEM = new UseItemPacketState();
        static final IPhaseState<BasicPacketContext> INVALID = new InvalidPacketState();
        static final IPhaseState<BasicPacketContext> START_RIDING_JUMP = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> ANIMATION = new AnimationPacketState();
        static final IPhaseState<BasicPacketContext> PRESS_SHIFT_KEY = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> RELEASE_SHIFT_KEY = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> START_SPRINTING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SPRINTING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SLEEPING = new StopSleepingPacketState();
        public static final IPhaseState<BasicPacketContext> CLOSE_WINDOW = new CloseWindowState();
        static final IPhaseState<BasicPacketContext> UPDATE_SIGN = new UpdateSignState();
        static final IPhaseState<BasicPacketContext> RESOURCE_PACK = new ResourcePackState();
        static final IPhaseState<BasicPacketContext> STOP_RIDING_JUMP = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> HANDLED_EXTERNALLY = new UnknownPacketState();
        static final IPhaseState<BasicPacketContext> START_FALL_FLYING = new BasicPacketState();
    }
}

