/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;

public abstract class PacketState<P extends PacketContext<P>>
extends PooledPhaseState<P>
implements IPhaseState<P> {
    private final BiConsumer<CauseStackManager.StackFrame, P> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        if (ctx.packetPlayer != null) {
            frame.pushCause(ctx.packetPlayer);
        }
    });
    private final String desc = TrackingUtil.phaseStateToString("Packet", this);

    protected PacketState() {
    }

    protected static void processSpawnedEntities(ServerPlayerEntity player, SpawnEntityEvent event) {
        List<Entity> entities = event.getEntities();
        PacketState.processEntities(player, entities);
    }

    protected static void processEntities(ServerPlayerEntity player, Collection<Entity> entities) {
        for (Entity entity : entities) {
            EntityUtil.processEntitySpawn(entity, () -> Optional.of(((ServerPlayer)player).getUser()));
        }
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, P> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public void unwind(P phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    public boolean matches(int packetState) {
        return false;
    }

    @Override
    public void associateNeighborStateNotifier(P unwindingContext, BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        ServerPlayer player = ((PacketContext)unwindingContext).getSpongePlayer();
        Chunk chunk = minecraftWorld.getChunkAt(notifyPos);
        ((ChunkBridge)chunk).bridge$setBlockNotifier(notifyPos, player.getUniqueId());
    }

    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, P context) {
    }

    public boolean isPacketIgnored(IPacket<?> packetIn, ServerPlayerEntity packetPlayer) {
        return false;
    }

    public boolean shouldCaptureEntity() {
        return false;
    }

    public boolean spawnEntity(P context, Entity entity) {
        Player player = ((PhaseContext)context).getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a player", context));
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.SPAWN_TYPE, this.getEntitySpawnType(context));
            frame.addContext(EventContextKeys.CREATOR, ((ServerPlayer)player).getUser());
            frame.addContext(EventContextKeys.NOTIFIER, ((ServerPlayer)player).getUser());
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    public SpawnType getEntitySpawnType(P context) {
        return SpawnTypes.PLACEMENT.get();
    }

    public String toString() {
        return this.desc;
    }
}

